% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcanoplot.R
\name{volcanoplot}
\alias{volcanoplot}
\title{Volcano Plot}
\usage{
volcanoplot(
  DE_results,
  my_comparison = NULL,
  highlight_genes = NULL,
  log2FC_thresh = 0,
  padj_thresh = 0.05,
  del_csv = ",",
  outfolder = "./results"
)
}
\arguments{
\item{DE_results}{DESeq2 results table. Accepts both a file (.tsv, .csv, tab-separated .txt) or a dataframe (see example below). Requires 'log2FoldChange' and 'padj' columns.}

\item{my_comparison}{The comparison to plot (control_vs_treatment, a_vs_b, ...). If the user is employing the whole workflow use exactly the name of the comparison indicated in the comparison dataframe.}

\item{highlight_genes}{A (optional) list of genes the user would like to highlight (label) in the volcano plot. It accepts a dataframe, a character vector or a path to a file in .txt format.}

\item{log2FC_thresh}{Threshold value for log2(Fold Change) to highlight genes as differentially expressed (default = 0).}

\item{padj_thresh}{Threshold value for adjusted p-value to highlight genes as  significant (default = 0.05).}

\item{del_csv}{Specify the delimiter of the .csv file (default = ","). This is because opening .csv files with Excel messes up the format and changes the delimiter to ";".}

\item{outfolder}{The name to assign to the folder for output saving. (Default = "./results").}
}
\value{
No return value. Files will be produced as part of normal execution.
}
\description{
Once the differential analysis has been performed, it is possible to visualize the volcano plots employing this function.

The volcano plot is generated by the employment of ggplot2, setting xlimit and ylimit based on the data. If there are genes with pvalue equal to infinity, those are forced to the maximum value of the pvalue. If 'my_comparison' paramater is not provided (default: NULL), the function will extract the name of the first subfolder inside "./results" and use it. The volcano plots are saved in the a subfolder for each comparison (Figure 1).
}
\examples{
\dontrun{
filename <- "./results/H460.2D_vs_H460.3D.2p/DE_H460.2D_vs_H460.3D.2p_allres.tsv"
volcanoplot(
  DE_results = filename,
  my_comparison = "H460.2D_vs_H460.3D.2p",
  log2FC_thresh = 0,
  padj_thresh = 0.05,
  highlight_genes = NULL,
  del_csv = ",",
  outfolder = "./results"
)
}
}
