% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mean_squared_error}
\alias{mean_squared_error}
\title{Estimates the mean squared prediction error.}
\usage{
mean_squared_error(pred, data.valid, y, L2.unit)
}
\arguments{
\item{pred}{Predictions of outcome. A numeric vector of outcome predictions.}

\item{data.valid}{Test data set. A tibble of data that was not used for
prediction.}

\item{y}{Outcome variable. A character vector containing the column names of
the outcome variable.}

\item{L2.unit}{Geographic unit. A character scalar containing the column name
of the geographic unit in \code{survey} and \code{census} at which outcomes
should be aggregated.}
}
\value{
Returns a tibble containing two mean squared prediction errors. The
  first is measured at the level of individuals and the second is measured at
  the context level. The tibble dimensions are 2x3 with variables: measure,
  value and level.
}
\description{
\code{mean_squared_error()} estimates the mean squared error for the desired
loss unit.
}
