% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoReg.coxph.R
\name{autoRegCox}
\alias{autoRegCox}
\title{perform automatic regression for a class of coxph}
\usage{
autoRegCox(
  x,
  threshold = 0.2,
  uni = FALSE,
  multi = TRUE,
  final = FALSE,
  imputed = FALSE,
  keepstats = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class coxph}

\item{threshold}{numeric}

\item{uni}{logical whether or not perform univariable regression}

\item{multi}{logical whether or not perform multivariable regression}

\item{final}{logical whether or not perform stepwise backward elimination}

\item{imputed}{logical whether or not perform multiple imputation}

\item{keepstats}{logical whether or not keep statistic}

\item{...}{Further arguments to be passed to gaze()}
}
\value{
autoRegCox returns an object of class "autoReg" which inherits from the class "data.frame"
with at least the following attributes:
\describe{
\item{attr(*,"yvars)}{character. name of dependent variable}
\item{attr(*,"model")}{name of model. One of "lm","glm" or "coxph"}
}
}
\description{
perform automatic regression for a class of coxph
}
\examples{
require(survival)
require(dplyr)
data(cancer)
fit=coxph(Surv(time,status==2)~log(bili)+age+cluster(edema),data=pbc)
autoReg(fit)
fit=coxph(Surv(time,status)~rx+age+sex+nodes+obstruct+perfor,data=colon)
autoReg(fit)
autoReg(fit,uni=TRUE,threshold=1)
autoReg(fit,uni=TRUE,final=TRUE) \%>\% myft()
data(colon_s,package="finalfit")
fit=coxph(Surv(time,status)~age.factor+sex.factor+obstruct.factor+perfor.factor,data=colon_s)
autoReg(fit,uni=TRUE,threshold=1)
autoReg(fit,uni=TRUE,imputed=TRUE)
}
