% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaze.R, R/gaze.coxph.R
\name{gaze}
\alias{gaze}
\alias{gaze.formula}
\alias{gaze.data.frame}
\alias{gaze.coxph}
\alias{gaze.survreg}
\alias{gaze.glm}
\alias{gaze.lm}
\alias{gaze.tidycrr}
\title{Produce table for descriptive statistics}
\usage{
gaze(x, ...)

\method{gaze}{formula}(x, ...)

\method{gaze}{data.frame}(x, ...)

\method{gaze}{coxph}(x, ...)

\method{gaze}{survreg}(x, ...)

\method{gaze}{glm}(x, ...)

\method{gaze}{lm}(x, ...)

\method{gaze}{tidycrr}(x, ...)
}
\arguments{
\item{x}{An R object, formula or data.frame}

\item{...}{arguments to be passed to gaze.data.frame or gaze.formula}
}
\value{
An object of class "gaze" which inherits from the class "data.frame"
with at least the following attributes:
\describe{
\item{attr(*,"yvars)}{character. name of dependent variable}
}
}
\description{
Produce table for descriptive statistics by groups for several variables easily.
Depending on  the nature of these variables, different descriptive statistical
methods were used(t-test, ANOVA, Kruskal-Wallis, chi-squared, Fisher's,...)
}
\section{Methods (by class)}{
\itemize{
\item \code{formula}: S3 method for formula

\item \code{data.frame}: default S3 method

\item \code{coxph}: default S3 method

\item \code{survreg}: default S3 method

\item \code{glm}: default S3 method

\item \code{lm}: default S3 method

\item \code{tidycrr}: default S3 method
}}

\examples{
library(moonBook)
library(dplyr)
gaze(acs)
gaze(~age+sex,data=acs)
gaze(sex~.,data=acs,digits=1,method=1,show.p=TRUE) \%>\% myft()
\donttest{
gaze(sex~age+Dx,data=acs)
gaze(EF~.,data=acs) \%>\% myft()
gaze(sex+Dx~.,data=acs,show.p=TRUE) \%>\% myft()
gaze(sex+Dx~.,data=acs)
gaze(Dx+sex~cardiogenicShock,data=acs,show.p=TRUE) \%>\% myft()
gaze(Dx+sex+HBP~cardiogenicShock,data=acs,show.p=TRUE)
gaze(~mpg+cyl,data=mtcars)
gaze(~.,data=mtcars)
gaze(cyl~.,data=mtcars,show.p=TRUE)
gaze(hp~.,data=mtcars)
gaze(cyl+am~.,data=mtcars)
}
library(survival)
x=coxph(Surv(time,status) ~rx,data=anderson1)
gaze(x)
x=coxph(Surv(time,status) ~rx*logWBC,data=anderson1)
gaze(x)
library(survival)
x=survreg(Surv(time, status) ~ rx, data=anderson,dist="exponential")
gaze(x)
x=survreg(Surv(time, status) ~ ph.ecog + age + sex, lung)
gaze(x)
data(cancer,package="survival")
fit=glm(status~rx+sex+age+obstruct+nodes,data=colon,family="binomial")
gaze(fit)
fit=lm(mpg~wt*hp+am+I(wt^2),data=mtcars)
gaze(fit)
data(melanoma,package="boot")
melanoma$status_crr=ifelse(melanoma$status==1,1,ifelse(melanoma$status==2,0,2))
fit=crrFormula(time+status_crr~age+sex+thickness+ulcer,data=melanoma)
gaze(fit)
}
