% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit2summary.R
\name{fit2summary}
\alias{fit2summary}
\title{Summarize statistics with a model or model list}
\usage{
fit2summary(fit, mode = 1, ...)
}
\arguments{
\item{fit}{An object of class "lm" or "glm" or "fitlist" which is a result of \code{\link{fit2list}}}

\item{mode}{integer}

\item{...}{Further argument to be passed to fit2stats}
}
\value{
An object of class "data.frame"
}
\description{
Summarize statistics with a model or model list
}
\examples{
library(survival)
data(cancer)
fit=glm(status~rx+sex+age+obstruct+nodes,data=colon,family="binomial")
fit2summary(fit)
fitlist=fit2list(fit)
fit2summary(fitlist)
fit=survreg(Surv(time,status)~rx+sex+age+obstruct+nodes,data=colon)
fit2summary(fit)
}
