% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglogplot.R
\name{loglogplot}
\alias{loglogplot}
\title{Draw log-log plot}
\usage{
loglogplot(
  fit,
  xnames = NULL,
  main = NULL,
  labels = NULL,
  no = 3,
  add.loess = FALSE,
  add.lm = TRUE,
  type = "l",
  se = TRUE,
  what = "surv",
  legend.position = NULL,
  ...
)
}
\arguments{
\item{fit}{An object of class "coxph" or "survfit"}

\item{xnames}{character Names of explanatory variable to plot}

\item{main}{String Title of plot}

\item{labels}{String vector Used as legend in legend}

\item{no}{Numeric The number of groups to be converted}

\item{add.loess}{logical If true, add loess regression line}

\item{add.lm}{logical If true, add linear regression line}

\item{type}{character "l" or "p"}

\item{se}{logical If true, add se}

\item{what}{character One of c("surv","survOdds","failureOdds")}

\item{legend.position}{legend position. One of c("left","top","bottom","right") or numeric vector of length 2.}

\item{...}{Furhter arguments to be passed to plot()}
}
\value{
A ggplot or no return value, called for side effects
}
\description{
Draw log-log plot
}
\examples{
require(survival)
data(cancer,package="survival")
fit=coxph(Surv(time,status)~x,data=leukemia)
loglogplot(fit)
fit=survfit(Surv(time,status)~1,data=anderson)
loglogplot(fit)
fit=survfit(Surv(time,status)~sex,data=anderson)
loglogplot(fit)
fit=survfit(Surv(time,status)~logWBC,data=anderson)
loglogplot(fit)
fit=survfit(Surv(time,status)~logWBC+rx,data=anderson)
loglogplot(fit,no=2)
fit=survfit(Surv(time,status)~rx,data=anderson)
loglogplot(fit,type="p")
fit=survfit(Surv(time,status)~WBCCAT,data=anderson2)
loglogplot(fit,type="p",what="survOdds")
loglogplot(fit,type="p",what="failureOdds")
}
