% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multFac.R
\name{multFac}
\alias{multFac}
\title{Tests multiple factors}
\usage{
multFac(facList, parallel = "no", ncore = 1, method = "GA",
  missing = "listwise", data = NULL, varList = NULL, criterion = "BIC",
  minInd = 3, niter = "default", CV = FALSE, min.improve = niter,
  seed = NULL, std.lv = TRUE, ...)
}
\arguments{
\item{facList}{A vector containing the number of factors to test. Ex: ll = c(1,2,3)}

\item{parallel}{Whether to use the snowfall package for parallelization. Note that
this is different than in autoSEM. Parallelization with multFac runs the
different factor models separately, not in the actual search algorithm.}

\item{ncore}{Number of cores to use.}

\item{method}{which optimization algorithm to use. Currently, it is only
recommended to use "GA" for the genetic algorithm from the GA
package, "aco", an implementation of the ant colony
algorithm by Ross Jacobucci, and "tabu", an implementation of
the Tabu search procedure by Ross Jacobucci. The latter two
algorithms are based on the book chapter by Marcoulides &
Leite, 2013.}

\item{missing}{Argument to be passed to cfa() as to what to do with missing
values. Note: missing="fiml" can't be paired with CV=TRUE}

\item{data}{a required dataset to search with.}

\item{varList}{list containing the names of the
variables to use from the dataset.}

\item{criterion}{The fit index to use as a criterion for
choosing the best model. Current options are "NCP",
"RMSEA", and "BIC".}

\item{minInd}{The minimum number of indicators per factor.}

\item{niter}{The maximum number of iterations to use. "default" changes the number
of iterations based on the algorithm used.}

\item{CV}{Whether to use cross-validation for choosing the best model. The
default is to use fit indices without CV.}

\item{min.improve}{Number of iterations to wait for improvement
before breaking.}

\item{seed}{random seed number.}

\item{std.lv}{Defaults to true. So lavaan uses all variables for each factor}

\item{...}{Additional arguments to pass to cfa(). An example is
is setting orth=FALSE,std.lv=TRUE.}
}
\description{
Tests multiple factors
}
\examples{
\dontrun{
library(autoSEM)
myData =  HolzingerSwineford1939[,7:15]

f1.vars <- c("x1","x2","x3","x4","x5","x6","x7","x8","x9")
rrr = list(f1.vars)
facs <- 1:4

out = multFac(facList=facs,parallel="yes",ncore=4,method="GA",
            data=myData,orth=FALSE,CV=FALSE,std.lv=TRUE,
            varList=rrr,criterion="RMSEA",niter="default")
}
}
\keyword{multFac}

