% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{d2}
\alias{d2}
\title{Generate D2 input text to plot objects}
\usage{
d2(x, ...)
}
\arguments{
\item{x}{an object to be plotted.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A scalar character, containing text input for D2.
}
\description{
Produces text input for D2 to make a diagram of a given object, usually
rendered with SVG.
}
\details{
The D2 language is in an early stage of development (pre-v1.0), so it may be
subject to changes that make it unable to use output from the current version
of \code{d2}.

Details of what is plotted are given in individual methods. There are
expected commonalities, which are described below.

The object is expected to be one of the following:
\itemize{
\item an object whose elements have the same length. Examples would be
data frames, matrices, and other objects that can represent relations, with
names for the elements, and an optional name for the object itself.
\item a graph of sub-objects, each of which represent a relation as
described above, possibly with connections between the objects, and an
optional name for the graph as a whole.
}

Each relation is presented as a record-like shape, with the following elements:
\itemize{
\item A optional header with the relation's name, and the number of (unique)
records.
\item A set of rows, one for each attribute in the relation. These rows
have the following contents:
\itemize{
\item the attribute names.
\item a depiction of the relation's (candidate) keys. Each
column represents a key, and a filled cell indicates that the attribute
in that row is in that key. The keys are given in lexical order, with
precedence given to keys with fewer attributes, and keys with attributes
that appear earlier in the original data frame's attribute order. Default
output from other package functions will thus have the primary key given
first. In the future, this will be changed to always give the primary key
first.
\item optionally, the attribute types: specifically, the first element
when passing the attribute's values into \code{\link{class}}.
}
}

Any foreign key references between relations are represented by one-way arrows,
one per attribute in the foreign key.

If the object has a name, then currently the name is not used, except as a
single data frame's name. In the future, this will be used to give a name to
the generated board, to make use of D2's composition features.
}
\examples{
\dontrun{
# simple data.frame example
cat(d2(ChickWeight, "chick"))
}
}
\seealso{
\code{\link{d2.data.frame}} and \code{\link{d2.relation_schema}} for
individual methods.

D2 language site: \url{https://d2lang.com}

Playground for running online without installation:
\url{https://play.d2lang.com/}

Quarto extension: \url{https://github.com/data-intuitive/quarto-d2}
}
