% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional_dependency.r
\name{functional_dependency}
\alias{functional_dependency}
\title{Functional dependency vectors}
\usage{
functional_dependency(FDs, attrs_order, unique = TRUE)
}
\arguments{
\item{FDs}{a list of functional dependencies, in the form of two-elements
lists: the first element contains a character vector of all attributes in
the determinant set, and the second element contains the single dependent
attribute (dependant).}

\item{attrs_order}{a character vector, giving the names of all attributes.
These need not be present in \code{FDs}, but all attributes in \code{FDs}
must be present in \code{attrs}.}

\item{unique}{a logical, TRUE by default, for whether to remove duplicate
dependencies.}
}
\value{
A \code{functional_dependency} object, containing the list given in
\code{FDs}, with \code{attrs_order} an attribute of the same name.
Functional dependencies are returned with their determinant sets sorted
according to the attribute order in \code{attrs}. Any duplicates found
after sorting are removed.
}
\description{
Creates a set of functional dependencies with length-one dependants.
}
\details{
When several sets of functional dependencies are concatenated, their
\code{attrs_order} attributes are merged, so as to preserve all of the
original attribute orders, if possible. If this is not possible, because the
orderings disagree, then the returned value of the \code{attrs_order}
attribute is their union instead.
}
\examples{
fds <- functional_dependency(
  list(list(c("a", "b"), "c"), list(character(), "d")),
  attrs_order = c("a", "b", "c", "d")
)
print(fds)
detset(fds)
dependant(fds)
attrs_order(fds)

# vector operations
fds2 <- functional_dependency(list(list("e", "a")), c("a", "e"))
c(fds, fds2) # attrs_order attributes are merged
unique(c(fds, fds))

# subsetting
fds[1]
fds[c(1, 2, 1)]
stopifnot(identical(fds[[2]], fds[2]))

# reassignment
fds3 <- fds
fds3[2] <- functional_dependency(list(list("a", "c")), attrs_order(fds3))
print(fds3)
detset(fds3)[[2]] <- character()
dependant(fds3)[[2]] <- "d"
stopifnot(identical(fds3, fds))
# changing appearance priority for attributes
attrs_order(fds3) <- rev(attrs_order(fds3))
fds3

# reconstructing from components
fds_recon <- functional_dependency(
 Map(list, detset(fds), dependant(fds)),
 attrs_order(fds)
)
stopifnot(identical(fds_recon, fds))

# can be a data frame column
data.frame(id = 1:2, fd = fds)

# (in)equality ignores header
stopifnot(all(fds3 == fds))
stopifnot(!any(fds != fds))
}
\seealso{
\code{\link{detset}}, \code{\link{dependant}}, and
\code{\link{attrs_order}} for extracting parts of the information in a
\code{functional_dependency}; \code{\link{rename_attrs}}
for renaming the attributes in \code{attrs_order}.
}
