% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reset_path.R
\name{reset_path}
\alias{reset_path}
\title{Reset search path of current R session}
\usage{
reset_path(old_path)
}
\arguments{
\item{old_path}{A character vector of package namespaces. This is usually 
the output of \code{\link[base]{search}}, run before an R script or Rmd 
file is rendered, which could cause the search path to change.}
}
\value{
There is no object returned. This function is called for it's side-
effect of altering the search path.
}
\description{
This function is used to detach packages that have been added by a student 
script.
}
\details{
When a student script is rendered using \code{\link{render_one}}, 
new packages might be added to the search path. These may conflict with the 
instructors' search path order, or with subsequent runs of 
\code{\link{render_one}} on students. Hence there is a need to reset the 
search path before this is done.

This function does not unload namespaces. It only detaches them from the 
search path. For a difference between the two, please see Hadley's page.
}
\examples{
opath <- search()
# Load a package
reset_path(opath)
}
