% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unihdma.R
\name{unihdma}
\alias{unihdma}
\title{High dimensional survival analysis using Bayesian univariate cox prportional
       hazard with mediation analysis}
\usage{
unihdma(m, n, survdur, event, LC = NULL, t, i, b, d, data)
}
\arguments{
\item{m}{Starting column number from where high dimensional variates to be selected.}

\item{n}{Ending column number till where high dimensional variates to be selected.}

\item{survdur}{"Column/Variable name" consisting duration of survival.}

\item{event}{"Column/Variable name" consisting survival event.}

\item{LC}{"Initial time of getting in to the study.}

\item{t}{A numeric between 0 to 100.}

\item{i}{Number of MCMC iteration to perform in obtaining posterior extimates of HR by CoxPH.}

\item{b}{Number of MCMC iterations to burn.}

\item{d}{Number of draws for the iterations.}

\item{data}{High dimensional data containing survival observations and high dimensional covariates.}
}
\value{
Data frame containing the beta and alpha values of active variables among the significant variables.
}
\description{
Given the dimension of variables and survival information the function filters significant variables
allowing the user to perform survival anlaysis with high number of iterations. Further, it performs mediation analysis among the signifiant
variables and provides handful variables with their alpha.a values which are mediator model exposure coefficients
and beta.a coefficients.
}
\examples{
##
unihdma(m=8,n=15,survdur="os",event="death",LC="leftcensoring",t=0.02,i=6,b=10,d=10,data=hnscc2)
##
}
