% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psegments.R
\name{psegments}
\alias{psegments}
\title{Projected segments function}
\usage{
psegments(x0, y0, x1 = x0, y1 = y0, proj, ...)
}
\arguments{
\item{x0, y0}{coordinates of points from which to draw.}

\item{x1, y1}{coordinates of points to which to draw}

\item{proj}{A character string indicating what projection should be
used for the included \code{x} and \code{y} coordinates.  The 
default is \code{"none"}.  The other valid choices correspond to 
the \code{"projection"} argument in the 
\code{\link[mapproj]{mapproject}} function, which is used for the
projection.}

\item{...}{Additional arguments to pass to the 
\code{\link[graphics]{segments}} function.}
}
\description{
\code{psegments} takes pairs of coordinates and draws line segments
between them, possibly after projection.
}
\details{
The \code{\link[mapproj]{mapproject}} function is used for 
projection.
}
\examples{
data(narccap)
# plot image using bonne projection (w/o grid lines)
pimage(lon, lat, tasmax[,,1], proj = "bonne",
       parameters = 40, paxes.args = list(grid = FALSE))
# some locations for u.s. cities
# taken from data(us.cities, package = "maps")
boston <- c(-71.02, 42.34)
la <- c(-118.41, 34.11)
ny <- c(-73.94, 40.67)
sf <- c(-122.45, 37.77)
# plot segments between sf, la and ny boston
x0 <- c(sf[1], ny[1])
y0 <- c(sf[2], ny[2])
x1 <- c(la[1], boston[1])
y1 <- c(la[2], boston[2])
psegments(x0, y0, x1, y1, proj = "bonne", lwd = 3)
citycoords <- rbind(sf, la, ny, boston)
cityxy <- list(x = citycoords[,1], y = citycoords[,2])
citynames <- c("san francisco", "los angeles", "new york", "boston") 
ptext(cityxy, labels = citynames, proj = 'bonne')
}
\seealso{
\code{\link[graphics]{segments}}, 
  \code{\link[mapproj]{mapproject}}, 
  \code{\link[autoimage]{pimage}}
}

