% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appendix.R
\name{postprocessing_doc}
\alias{postprocessing_doc}
\title{Post-process PowerPoint Document}
\usage{
postprocessing_doc(doc, save_file, doc_o, type = "")
}
\arguments{
\item{doc}{An `officer::rpptx` object to finalize.}

\item{save_file}{A boolean indicating whether to save the file to disk.}

\item{doc_o}{Original PowerPoint file path.}

\item{type}{A string suffix to label the output file, e.g., `"cohort_sec"` or `"safety_sum_sec"`.}
}
\value{
The modified `officer::rpptx` object.
}
\description{
Performs final actions on the PowerPoint object, including optionally saving the updated file.
The saved filename includes a suffix indicating the slide type that was appended.
}
\examples{
tmp <- tempfile(fileext = ".pptx")
doc <- officer::read_pptx()
doc <- officer::add_slide(doc, layout = "Title Slide", master = "Office Theme")
print(doc, target = tmp)
doc <- officer::read_pptx(tmp)
# Call postprocessing_doc to save a modified version of doc
postprocessing_doc(doc, TRUE, tmp, type = "final")
}
