% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_genome_id_from_logic_operation.R
\name{get_genome_id_from_logic_operation}
\alias{get_genome_id_from_logic_operation}
\title{Get genome from logic operations}
\usage{
get_genome_id_from_logic_operation(
  logic_operation,
  seed_id = FALSE,
  genome_seq = FALSE
)
}
\arguments{
\item{logic_operation}{List of logical operations from the following set:
"equals", "exclusive-or", "not-or", "and-not", "or", "orn-not", "and",
"not-and", "not".}

\item{seed_id}{Integer (from 1 to 1000), a vector of integer
values, or a logical value. This integer is used for starting the
pseudo-random number generator that represents the environment experiencing a
digital organism. If a logical value is used, TRUE returns data found in all
environments and FALSE (by default) returns only distinct data regardless of
the seed.}

\item{genome_seq}{Logical value (TRUE/FALSE) to show/hide this column
("FALSE" by default).}
}
\value{
Data frame. Columns: "seed_id" (optional), "genome_id", "genome_seq" (optional).
}
\description{
Get the genome of a digital organism that encodes a unique
combination of logic operations for a list of seeds used for starting the
pseudo-random number generator (i.e., a set of environments).
}
\examples{

# Single logic operation
get_genome_id_from_logic_operation(logic_operation = "not-or")

# More than one logic operation
get_genome_id_from_logic_operation(logic_operation = c("not", "not-and"))

# At seed_1
get_genome_id_from_logic_operation(
  logic_operation = c("or", "equals", "and"),
  seed_id = 1,
  genome_seq = TRUE
)

}
