% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.multiAvophylo}
\alias{plot.multiAvophylo}
\title{Plot Model Fits for an 'multiAvophylo' Object}
\usage{
\method{plot}{multiAvophylo}(
  x,
  tips = "extinct",
  tips_col = NULL,
  order = NULL,
  family = NULL,
  genus = NULL,
  species = NULL,
  avotrex,
  tax,
  lvls = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class 'multiAvophylo'.}

\item{tips}{What tip labels to present. Can be one of
"extinct" (just tip labels of extinct species), "none" (no
tip labels) or "all_same" (show all labels, with same colour
labels for all species), or "all_dif" (show all labels, with
different colour labels for extant and extinct species).
The latter needs to be used in combination with the
\code{tips_col} argument.}

\item{tips_col}{Colour of tip labels. If \code{tips =
"all_dif"} this needs to be a vector of length two, with the
first value being the colour for extinct species, and the
second for extant species.}

\item{order}{Prune the tree to only show a specific order
(should be a character vector of length = 1). Taxonomy
follows BirdTree, see the \code{data(BirdTree_taxa)} file.
For extinct order names, see the \code{data(AvotrexPhylo)}
file.}

\item{family}{As for \code{order}, but for families.}

\item{genus}{As for \code{order}, but for genera.}

\item{species}{Prune the tree to only show a specific set of
species. Should be a vector of at least length = 1. If only
a single species name is provided, the \code{lvls} argument
also needs to be provided.}

\item{avotrex}{The Avotrex phylo dataset used to generate the
trees. For most use cases, this will have been loaded using
\code{data(AvotrexPhylo)}.}

\item{tax}{The Jetz et al. (2012) BirdTree taxonomy .csv.
Supplied as data within the package.}

\item{lvls}{If \code{species} is just a single species, how
many levels back (rootward) should be plotted. Uses the
\code{tidytree::tree_subset} function (see help
documentation of that function for further info).}

\item{\dots}{Other plotting arguments from the ape package's
\link[ape]{plot.phylo} can be provided.}
}
\value{
Generates a phylogeny plot for each tree in \code{x}.
}
\description{
S3 method for class 'multiAvophylo'. See the
  \code{\link{plot.avophylo}} documentation for more
  information.
  
  Plots individual trees in turn (with the user required to
  press 'enter' to move to the next plot).
}
\examples{
#See the plot.avophylo documentation for further examples
data(treesEx)
#family (plot both trees in turn)
plot(treesEx, avotrex = AvotrexPhylo, tax = BirdTree_tax,
     family = "Threskiornithidae", tips = "extinct",
     tip.color = "red", cex = 0.5)
}
