% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_customer_gateway}
\alias{ec2_delete_customer_gateway}
\title{Delete Customer Gateway}
\usage{
ec2_delete_customer_gateway(
  CustomerGatewayId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{CustomerGatewayId}{String. The ID of the customer gateway.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deletes the specified customer
gateway. You must delete the VPN connection before you can delete the
customer gateway.
}
\section{CustomerGatewayId}{

The ID of the customer
gateway.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

