% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_delete_launch_template}
\alias{ec2_delete_launch_template}
\title{Delete Launch Template}
\usage{
ec2_delete_launch_template(
  DryRun = NULL,
  LaunchTemplateId = NULL,
  LaunchTemplateName = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{LaunchTemplateId}{String. The ID of the launch template.[optional]}

\item{LaunchTemplateName}{String. The name of the launch template.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Deletes a launch
template. Deleting a launch template deletes all of its
versions.
}
\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{LaunchTemplateId}{

The ID of the launch
template. You must specify either the launch template ID or launch
template name in the request.
}

\section{LaunchTemplateName}{

The name of the launch
template. You must specify either the launch template ID or launch
template name in the request.
}

