% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_default_credit_specification}
\alias{ec2_modify_default_credit_specification}
\title{Modify Default Credit Specification}
\usage{
ec2_modify_default_credit_specification(
  InstanceFamily,
  CpuCredits,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{InstanceFamily}{String. The instance family.}

\item{CpuCredits}{String.   The credit option for CPU usage of the instance family.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Default Credit Specification
}
\section{InstanceFamily}{

The instance
family.
}

\section{CpuCredits}{


The credit option for CPU usage of the instance family.

Valid Values: \code{standard} \| \code{unlimited}
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

