% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_restore_managed_prefix_list_version}
\alias{ec2_restore_managed_prefix_list_version}
\title{Restore Managed Prefix List Version}
\usage{
ec2_restore_managed_prefix_list_version(
  PrefixListId,
  PreviousVersion,
  CurrentVersion,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{PrefixListId}{String. The ID of the prefix list.}

\item{PreviousVersion}{Integer. The version to restore.}

\item{CurrentVersion}{Integer. The current version number for the prefix list.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Restores the entries
from a previous version of a managed prefix list to a new version of the
prefix list.
}
\section{PrefixListId}{

The ID of the prefix
list.
}

\section{PreviousVersion}{

The version to
restore.
}

\section{CurrentVersion}{

The current version number for the prefix
list.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

