% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_availability_zones}
\alias{ec2_describe_availability_zones}
\title{Describe Availability Zones}
\usage{
ec2_describe_availability_zones(
  Filter = NULL,
  ZoneName = NULL,
  ZoneId = NULL,
  AllAvailabilityZones = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{ZoneName}{List. The names of the Availability Zones, Local Zones, and Wavelength Zones.[optional]}

\item{ZoneId}{List. The IDs of the Availability Zones, Local Zones, and Wavelength Zones.[optional]}

\item{AllAvailabilityZones}{Logical.   Include all Availability Zones, Local Zones, and Wavelength Zones regardless of your opt-in status....[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describe Availability Zones
}
\section{Filter}{


The filters.
\itemize{
\item \code{group-name} - For Availability Zones, use the Region name. For
Local Zones, use the name of the group associated with the Local
Zone (for example, \code{us-west-2-lax-1}) For Wavelength Zones, use the
name of the group associated with the Wavelength Zone (for example,
\code{us-east-1-wl1-bos-wlz-1}).
\item \code{message} - The Zone message.
\item \verb{opt-in-status} - The opt-in status (\verb{opted-in}, and \verb{not-opted-in}
\| \verb{opt-in-not-required}).
\item \code{parent-zoneID} - The ID of the zone that handles some of the Local
Zone and Wavelength Zone control plane operations, such as API
calls.
\item \code{parent-zoneName} - The ID of the zone that handles some of the
Local Zone and Wavelength Zone control plane operations, such as API
calls.
\item \code{region-name} - The name of the Region for the Zone (for example,
\code{us-east-1}).
\item \code{state} - The state of the Availability Zone, the Local Zone, or the
Wavelength Zone (\code{available} \| \code{information} \| \code{impaired} \|
\code{unavailable}).
\item \code{zone-id} - The ID of the Availability Zone (for example,
\code{use1-az1}), the Local Zone (for example, \code{usw2-lax1-az1}), or the
Wavelength Zone (for example, \code{us-east-1-wl1-bos-wlz-1}).
\item \code{zone-type} - The type of zone, for example, \code{local-zone}.
\item \code{zone-name} - The name of the Availability Zone (for example,
\verb{us-east-1a}), the Local Zone (for example, \verb{us-west-2-lax-1a}), or
the Wavelength Zone (for example, \code{us-east-1-wl1-bos-wlz-1}).
\item \code{zone-type} - The type of zone, for example, \code{local-zone}.
}
}

\section{ZoneName}{

The names of the Availability Zones, Local Zones,
and Wavelength Zones.
}

\section{ZoneId}{

The IDs of the Availability
Zones, Local Zones, and Wavelength Zones.
}

\section{AllAvailabilityZones}{


Include all Availability Zones, Local Zones, and Wavelength Zones
regardless of your opt-in status.

If you do not use this parameter, the results include only the zones for
the Regions where you have chosen the option to opt in.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

