% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3saveRDS.R
\name{s3saveRDS}
\alias{s3saveRDS}
\alias{s3readRDS}
\title{saveRDS/readRDS}
\usage{
s3saveRDS(x, object = paste0(as.character(substitute(x)), ".rds"), bucket,
  compress = TRUE, ...)

s3readRDS(object, bucket, ...)
}
\arguments{
\item{x}{For \code{s3saveRDS}, a single R object to be saved via \code{\link[base]{saveRDS}} and uploaded to S3. \code{x} is analogous to the \code{object} argument in \code{saveRDS}.}

\item{object}{Character string with the object key, or an object of class \dQuote{s3_object}. In most cases, if \code{object} is specified as the latter, \code{bucket} can be omitted because the bucket name will be extracted from \dQuote{Bucket} slot in \code{object}.}

\item{bucket}{Character string with the name of the bucket, or an object of class \dQuote{s3_bucket}.}

\item{compress}{A logical. See \code{\link[base]{saveRDS}}.}

\item{\dots}{Additional arguments passed to \code{\link{s3HTTP}}.}
}
\value{
For \code{s3saveRDS}, a logical. For \code{s3readRDS}, an R object.
}
\description{
Serialization interface to read/write R objects to S3
}
\details{
Note that early versions of \code{s3saveRDS} from aws.s3 <= 0.2.4 unintentionally serialized objects to big endian format (due to defaults in \code{\link[base]{serialize}}. This can create problems when attempting to read these files using \code{\link[base]{readRDS}}. The function attempts to catch the issue and read accordingly, but may fail. The solution used internally is \code{unserialize(memDecompress(get_object(), "gzip"))}
}
\examples{
\dontrun{
# create bucket
b <- put_bucket("myexamplebucket")

# save a single object to s3
s3saveRDS(x = mtcars, bucket = "myexamplebucket", object = "mtcars.rds")

# restore it under a different name
mtcars2 <- s3readRDS(object = "mtcars.rds", bucket = "myexamplebucket")
identical(mtcars, mtcars2)

# cleanup
delete_object(object = "mtcars.rds", bucket = "myexamplebucket")
delete_bucket("myexamplebucket")
}
}
\seealso{
\code{\link{s3save}},\code{\link{s3load}}
}
\author{
Steven Akins <skawesome@gmail.com>
}
