% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/put_bucket.R
\name{put_bucket}
\alias{put_bucket}
\title{Create bucket}
\usage{
put_bucket(
  bucket,
  region = Sys.getenv("AWS_DEFAULT_REGION"),
  acl = c("private", "public-read", "public-read-write", "aws-exec-read",
    "authenticated-read", "bucket-owner-read", "bucket-owner-full-control"),
  location_constraint = region,
  headers = list(),
  ...
)
}
\arguments{
\item{bucket}{Character string with the name of the bucket, or an object of class \dQuote{s3_bucket}.}

\item{region}{A character string containing the AWS region. If missing, defaults to value of environment variable \env{AWS_DEFAULT_REGION}.}

\item{acl}{A character string indicating a \href{http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl}{\dQuote{canned} access control list}. By default all bucket contents and objects therein are given the ACL \dQuote{private}. This can later be viewed using \code{\link{get_acl}} and modified using \code{\link{put_acl}}.}

\item{location_constraint}{A character string specifying a location constraint. If \code{NULL} (for example, for S3-compatible storage), no LocationConstraint body is passed.}

\item{headers}{List of request headers for the REST call.}

\item{\dots}{Additional arguments passed to \code{\link{s3HTTP}}.}
}
\value{
\code{TRUE} if successful.
}
\description{
Creates a new S3 bucket.
}
\details{
Bucket policies regulate who has what access to a bucket and its contents. The \code{header} argument can beused to specify \dQuote{canned} policies and \code{\link{put_bucket_policy}} can be used to specify a more complex policy. The \href{https://awspolicygen.s3.amazonaws.com/policygen.html}{AWS Policy Generator} can be useful for creating the appropriate JSON policy structure.
}
\examples{
\dontrun{
  put_bucket("examplebucket")
  
  # set a "canned" ACL to, e.g., make bucket publicly readable
  put_bucket("examplebucket", headers = list(`x-amz-acl` = "public-read")

}
}
\references{
\href{http://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUT.html}{API Documentation}
\href{https://awspolicygen.s3.amazonaws.com/policygen.html}{AWS Policy Generator}
}
\seealso{
\code{\link{bucketlist}}, \code{\link{get_bucket}}, \code{\link{delete_bucket}}, \code{\link{put_object}}, \code{\link{put_encryption}}, \code{\link{put_versioning}}
}
