% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http.R
\name{snsHTTP}
\alias{snsHTTP}
\title{Execute SNS API Request}
\usage{
snsHTTP(query, region = Sys.getenv("AWS_DEFAULT_REGION", "us-east-1"),
  key = NULL, secret = NULL, session_token = NULL, ...)
}
\arguments{
\item{query}{An optional named list containing query string parameters and their character values.}

\item{region}{A character string containing an AWS region. If missing, the default \dQuote{us-east-1} is used.}

\item{key}{A character string containing an AWS Access Key ID. See \code{\link[aws.signature]{locate_credentials}}.}

\item{secret}{A character string containing an AWS Secret Access Key. See \code{\link[aws.signature]{locate_credentials}}.}

\item{session_token}{Optionally, a character string containing an AWS temporary Session Token. See \code{\link[aws.signature]{locate_credentials}}.}

\item{...}{Additional arguments passed to \code{\link[httr]{GET}}.}
}
\value{
If successful, a named list. Otherwise, a data structure of class \dQuote{aws-error} containing any error message(s) from AWS and information about the request attempt.
}
\description{
This is the workhorse function to execute calls to the SNS API.
}
\details{
This function constructs and signs an SNS API request and returns the results thereof, or relevant debugging information in the case of error.
}
\author{
Thomas J. Leeper
}
