% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelope_correlation.R
\name{envelope_correlation}
\alias{envelope_correlation}
\title{Measure amplitude envelope correlation}
\usage{
envelope_correlation(X, parallel = 1, pb = TRUE, method = 1, cor.method = "pearson", 
ssmooth = NULL, msmooth = NULL, output = "est", hop.size = 11.6, wl = NULL, ovlp = 70)
}
\arguments{
\item{X}{object of class 'extended_selection_table' created by the function \code{\link[warbleR]{selection_table}} from the warbleR package.}

\item{parallel}{Numeric vector of length 1. Controls whether parallel computing is applied by specifying the number of cores to be used. Default is 1 (i.e. no parallel computing).
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control if progress bar is shown. Default is \code{TRUE}.}

\item{method}{Numeric vector of length 1 to indicate the 'experimental design' to measure amplitude envelope correlation. Two methods are available:
\itemize{
\item \code{1}: compare all signals with their counterpart that was recorded at the closest distance to source (e.g. compare a signal recorded at 5m, 10m and 15m with its counterpart recorded at 1m). This is the default method. 
\item \code{2}: compare all signals with their counterpart recorded at the distance immediately before (e.g. a signal recorded at 10m compared with the same signal recorded at 5m, then signal recorded at 15m compared with same signal recorded at 10m and so on).
}}

\item{cor.method}{Character string indicating the correlation coefficient to be applied ("pearson", "spearman", or "kendall", see \code{\link[stats]{cor}}).}

\item{ssmooth}{Numeric vector of length 1 to determine the length of the sliding window used for a sum smooth for amplitude envelope calculation (used internally by \code{\link[seewave]{env}}).}

\item{msmooth}{Numeric vector of length 2 to smooth the amplitude envelope with a mean sliding window for amplitude envelope calculation. The first element is the window length (in number of amplitude values) and the second one the window overlap (used internally by \code{\link[seewave]{env}}).}

\item{output}{Character vector of length 1 to determine if an extended selection table ('est', default) or a data frame ('data.frame').}

\item{hop.size}{A numeric vector of length 1 specifying the time window duration (in ms). Default is 11.6 ms, which is equivalent to 512 wl for a 44.1 kHz sampling rate. Ignored if 'wl' is supplied.}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is NULL. If supplied, 'hop.size' is ignored.}

\item{ovlp}{Numeric vector of length 1 specifying the percent overlap between two 
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 70.}
}
\value{
Extended selection table similar to input data, but also includes two new columns ('reference' and  'envelope.correlation')
with the reference signal and the amplitude envelope correlation coefficients.
}
\description{
\code{envelope_correlation} measures amplitude envelope correlation of signals referenced in an extended selection table.
}
\details{
Amplitude envelope correlation measures the similarity of two signals in the time domain. The  function measures the envelope correlation coefficients of signals in which a reference playback has been re-recorded at increasing distances. Values close to 1 means very similar amplitude envelopes (i.e. little degradation has occurred). If envelopes have different lengths (which means signals have different lengths) cross-correlation is used and the maximum correlation coefficient is returned. Cross-correlation is achieved by sliding the shortest signal along the largest one and calculating the correlation at each step. The 'signal.type' column must be used to indicate the function to only compare signals belonging to the same category (e.g. song-types).The function compares each signal type to the corresponding reference signal within the supplied frequency range (e.g. bandpass) of the reference signal ('bottom.freq' and 'top.freq' columns in 'X'). Two methods for calculating envelope correlation are provided (see 'method' argument). Use \code{\link{blur_ratio}} to extract envelopes.
}
\examples{
{
# load example data
data("playback_est")

# remove ambient selections
playback_est <- playback_est[playback_est$signal.type != "ambient", ]

# method 1
envelope_correlation(X = playback_est)

# method 2
envelope_correlation(X = playback_est, method = 2)
}

}
\references{
{
Araya-Salas, M. (2020). baRulho: baRulho: quantifying habitat-induced degradation of (animal) acoustic signals in R. R package version 1.0.2

Apol, C.A., Sturdy, C.B. & Proppe, D.S. (2017). Seasonal variability in habitat structure may have shaped acoustic signals and repertoires in the black-capped and boreal chickadees. Evol Ecol. 32:57-74.
}
}
\seealso{
\code{\link{blur_ratio}}, \code{\link{spectral_blur_ratio}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
