% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spcc.R
\name{spcc}
\alias{spcc}
\title{Measure spectrographic cross-correlation as a measure of signal distortion}
\usage{
spcc(X, parallel = 1, pb = TRUE,  method = 1, 
cor.method = "pearson", output = "est", 
hop.size = 11.6, wl = NULL, ovlp = 90, wn = 'hanning')
}
\arguments{
\item{X}{object of class 'extended_selection_table' created by the function \code{\link[warbleR]{selection_table}} from the warbleR package. The object must include the following additional columns: 'signal.type', 'bottom.freq' and 'top.freq'.}

\item{parallel}{Numeric vector of length 1. Controls whether parallel computing is applied by specifying the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control if progress bar is shown. Default is \code{TRUE}.}

\item{method}{Numeric vector of length 1 to indicate the 'experimental design' for measuring envelope correlation. Two methods are available:
\itemize{
\item \code{1}: compare all signals with their counterpart that was recorded at the closest distance to source (e.g. compare a signal recorded at 5m, 10m and 15m with its counterpart recorded at 1m). This is the default method. 
\item \code{2}: compare all signals with their counterpart recorded at the distance immediately before (e.g. a signal recorded at 10m compared with the same signal recorded at 5m, then signal recorded at 15m compared with same signal recorded at 10m and so on).
}}

\item{cor.method}{Character string indicating the correlation coefficient to be applied ("pearson", "spearman", or "kendall", see \code{\link[stats]{cor}}).}

\item{output}{Character vector of length 1 to determine if an extended selection table ('est', default) or a data frame ('data.frame').}

\item{hop.size}{A numeric vector of length 1 specifying the time window duration (in ms). Default is 11.6 ms, which is equivalent to 512 wl for a 44.1 kHz sampling rate. Ignored if 'wl' is supplied.}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is NULL. If supplied, 'hop.size' is ignored.}

\item{ovlp}{Numeric vector of length 1 specifying \% of overlap between two 
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 90. High values of ovlp 
slow down the function but produce more accurate results.}

\item{wn}{A character vector of length 1 specifying the window name as in \code{\link[seewave]{ftwindow}}.}
}
\value{
Extended selection table similar to input data, but includes a new column (cross.correlation)
with the spectrogram cross-correlation coefficients.
}
\description{
\code{spcc} measures spectrographic cross-correlation as a measure of signal distortion in signals referenced in an extended selection table.
}
\details{
Spectrographic cross-correlation measures frequency distortion of signals as a similarity metric. Values close to 1 means very similar spectrograms (i.e. little signal distortion has occurred). Cross-correlation is measured of signals in which a reference playback has been re-recorded at increasing distances. The 'signal.type' column must be used to indicate the function to only compare signals belonging to the same category (e.g. song-types). The function compares each signal type to the corresponding reference signal within the supplied frequency range (e.g. bandpass) of the reference signal ('bottom.freq' and 'top.freq' columns in 'X'). Two methods for calculating cross-correlation are provided (see 'method' argument). The function is a wrapper on warbleR's \code{\link[warbleR]{xcorr}} function.
}
\examples{
{
# load example data
data("playback_est")

# method 1
spcc(X = playback_est, method = 1)

# method 2
spcc(X = playback_est, method = 2)
}

}
\references{
{
Araya-Salas, M. (2020). baRulho: baRulho: quantifying habitat-induced degradation of (animal) acoustic signals in R. R package version 1.0.2

Clark, C.W., Marler, P. & Beeman K. (1987). Quantitative analysis of animal vocal phonology: an application to Swamp Sparrow song. Ethology. 76:101-115. 
}
}
\seealso{
\code{\link{blur_ratio}}, \code{\link{spcc_align}}, \code{\link[warbleR]{xcorr}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
