% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_beast2_pkgs.R
\name{check_beast2_pkgs}
\alias{check_beast2_pkgs}
\title{Checks if \code{\link{bbt_run}} has the 'BEAST2' packages needed to process
its arguments. Will \link{stop} if not.}
\usage{
check_beast2_pkgs(mcmc, beast2_path = get_default_beast2_bin_path())
}
\arguments{
\item{mcmc}{the MCMC options,
see \link[beautier]{create_mcmc}}

\item{beast2_path}{name of either a 'BEAST2'  binary file
(usually simply \code{beast})
or a 'BEAST2'  jar file
(usually has a \code{.jar} extension).
Use \code{get_default_beast2_bin_path} to get
the default BEAST binary file's path
Use \code{get_default_beast2_jar_path} to get
the default BEAST jar file's path}
}
\description{
For example, to use a Nested Sampling MCMC, the 'BEAST2' 'NS' package
needs to be installed.
}
\examples{
library(testthat)

# This test uninstalls the NS 'BEAST2' package.
# Only do that on CI services, else a user without internet
# suddenly finds the NS 'BEAST2' package installed and unable
# to reinstall it
if (is_beast2_installed() && is_on_ci()) {

  # Check to need to install NS later
  was_ns_installed <- is_beast2_ns_pkg_installed()

  if (is_beast2_ns_pkg_installed()) {
    uninstall_beast2_pkg("NS")
  }

  # Without the NS 'BEAST2' package installed,
  # a Nested Sampling MCMC cannot be created.
  expect_false(is_beast2_ns_pkg_installed())
  expect_error(
    check_beast2_pkgs(
      mcmc = create_ns_mcmc()
    ),
    "Must install 'NS' to use 'create_ns_mcmc'."
  )

  install_beast2_pkg("NS")

  expect_silent(
    check_beast2_pkgs(
      mcmc = create_ns_mcmc()
    )
  )

  if (!was_ns_installed) {
    uninstall_beast2_pkg("BS")
  }
}
}
