% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logit.R
\name{logit}
\alias{logit}
\title{Logit-based probabilities for SDSM}
\usage{
logit(M)
}
\arguments{
\item{M}{matrix}
}
\value{
a matrix of probabilities
}
\description{
\code{logit} estimates cell probabilities under the logit model
}
\details{
Given a matrix \strong{M}, the logit model returns a valued matrix \strong{B} in which Bij is the \emph{approximate} probability
that Mij = 1 in the space of all binary matrices with the same row and column marginals as \strong{M}.

The Bipartite Configuration Model (BiCM), which is available using \link{bicm} is faster and yields slightly
more accurate probabilities (Neal et al., 2021). Therefore, it is the default used in \link{sdsm}. However,
the BiCM it requires the assumption that any cell in \strong{M} can take a value of 0 or 1.

In contrast, the logit model allows constraints on specific cells. If \strong{M} represents a bipartite graph, these
constraints are equivalent to structural 0s (an edge that can never be present) and structural 1s (an edge that
must always be present). To impose such constraints, \strong{M} should be binary, except that structural 0s are
represented with Mij = 10, and structural 1s are represented with Mij = 11.
}
\examples{
M <- matrix(c(0,0,1,0,1,0,1,0,1),3,3)  #A binary matrix
logit(M)
M <- matrix(c(0,10,1,0,1,0,1,0,11),3,3)  #A binary matrix with structural values
logit(M)
}
\references{
package: {Neal, Z. P. (2022). backbone: An R Package to Extract Network Backbones. \emph{PLOS ONE, 17}, e0269137. \doi{10.1371/journal.pone.0269137}}

logit model: {Neal, Z. P. (2014). The backbone of bipartite projections: Inferring relationships from co-authorship, co-sponsorship, co-attendance and other co-behaviors. \emph{Social Networks, 39}, 84-97. \doi{10.1016/j.socnet.2014.06.001}}

logit model with constraints: {Neal, Z. P. and Neal, J. W. (2024). Stochastic Degree Sequence Model with Edge Constraints (SDSM-EC) for Backbone Extraction. \emph{Proceedings of the 12th International Conference on Complex Networks and their Applications}. Springer.}
}
