% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-functions.R
\name{set_datamod_undercount}
\alias{set_datamod_undercount}
\title{Specify Undercount Data Model}
\usage{
set_datamod_undercount(mod, prob)
}
\arguments{
\item{mod}{An object of class \code{"bage_mod"},
created with \code{\link[=mod_pois]{mod_pois()}} or \code{\link[=mod_binom]{mod_binom()}}.}

\item{prob}{The prior for the probability
that a person or event in the target
population will correctly enumerated.
A data frame with a variable
called \code{"mean"}, a variable called \code{"disp"},
and, optionally, one or more 'by' variables.}
}
\value{
A revised version of \code{mod}.
}
\description{
Specify a data model for the outcome
in a Poisson or binomial model,
where the outcome
is subject to undercount.
}
\details{
The undercount data model assumes that
reported values for the outcome variable
understate the true values, because
the reported values miss some people
or events in the target population.
In other words, the probability that
any given unit in the target population
will be included in the reported outcome
is less than 1.
}
\section{The \code{prob} argument}{


The \code{prob} argument specifies a prior
distribution for the probability
that a person or event in the target
population is included in the
reported outcome. \code{prob} is a
data frame with a variable called \code{"mean"},
a variable called \code{"disp"}, and, optionally,
one or more 'by' variables.
For instance, a  \code{prob} of

\if{html}{\out{<div class="sourceCode">}}\preformatted{data.frame(sex = c("Female", "Male"),
           mean = c(0.95, 0.92),
           disp = c(0.02, 0.015))
}\if{html}{\out{</div>}}

implies that the expected value for
the inclusion probability is 0.95 for females
and 0.92 for males, with slightly more
uncertainty for females than for males.
}

\section{Mathematical details}{


The model for the observed outcome is

\deqn{y_i^{\text{obs}} \sim \text{Binomial}(y_i^{\text{true}}, \pi_{g[i]})}
\deqn{\pi_g \sim \text{Beta}(m_g^{(\pi)} / d_g^{(\pi)}, (1-m_g^{(\pi)}) / d_g^{(\pi)})}

where
\itemize{
\item \eqn{y_i^{\text{obs}}} is the observed outcome for cell \eqn{i};
\item \eqn{y_i^{\text{true}}} is the true outcome for cell \eqn{i};
\item \eqn{\pi_{g[i]}} is the probability that a member of the
target population in cell \eqn{i} is correctly enumerated in that cell;
\item \eqn{m_g} is the expected value for \eqn{\pi_g}
(specified via \code{prob}); and
\item \eqn{d_g} is disperson for \eqn{\pi_g} (specified via \code{prob}).
}
}

\examples{
## specify 'prob'
prob <- data.frame(sex = c("Female", "Male"),
                   mean = c(0.95, 0.97),
                   disp = c(0.05, 0.05))

## specify model
mod <- mod_pois(divorces ~ age * sex + time,
                data = nzl_divorces,
                exposure = population) |>
  set_datamod_undercount(prob)
mod

## fit model
mod <- mod |>
  fit()
mod

## original data, plus imputed values for outcome
mod |>
  augment()

## parameter estimates
library(dplyr)
mod |>
  components() |>
  filter(term == "datamod")

## the data have in fact been confidentialized,
## so we account for that, in addition
## to accounting for undercoverage
mod <- mod |>
 set_confidential_rr3() |>
 fit()
mod
}
\seealso{
\itemize{
\item \code{\link[=mod_pois]{mod_pois()}} Specify a Poisson model
\item \code{\link[=mod_binom]{mod_binom()}} Specify a binomial model
\item \code{\link[=augment]{augment()}} Original data plus estimated values,
including estimates of true value for
the outcome variable
\item \code{\link[=components]{components()}} Estimated values for
model parameters, including inclusion
probabilities and overcount rates
\item \code{\link[=set_datamod_overcount]{set_datamod_overcount()}} An overcount-only
data model
\item \code{\link[=set_datamod_miscount]{set_datamod_miscount()}} An undercount-and-overcount
data model
\item \link{datamods} All data models implemented in \code{bage}
\item \link{confidential} Confidentialization
procedures modeled in \code{bage}
\item \href{https://bayesiandemography.github.io/bage/articles/vig02_math.html}{Mathematical Details}
vignette
}
}
