% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_prior-constructors.R
\name{AR}
\alias{AR}
\title{Autoregressive Prior}
\usage{
AR(n_coef = 2, s = 1, along = NULL)
}
\arguments{
\item{n_coef}{Number of lagged terms in the
model, ie the order of the model. Default is \code{2}.}

\item{s}{Scale for the prior for the innovations.
Default is \code{1}.}

\item{along}{Name of the variable to be used
as the "along" variable. Only used with
interactions.}
}
\value{
An object of class \code{"bage_prior_ar"}.
}
\description{
Use an autoregressive process to model
a main effect, or use multiple autoregressive
processes to model an interaction.
Typically used with time effects or with
interactions that involve time.
}
\details{
If \code{AR()} is used with an interaction,
separate AR processes are constructed along
the "along" variable, within each combination of the
"by" variables.

By default, the autoregressive processes
have order 2. Alternative choices can be
specified through the \code{n_coef} argument.

Argument \code{s} controls the size of innovations.
Smaller values for \code{s} tend to give smoother estimates.
}
\section{Mathematical details}{


When \code{AR()} is used with a main effect,

\deqn{\beta_j = \phi_1 \beta_{j-1} + \cdots + \phi_n \beta_{j-n} + \epsilon_j}
\deqn{\epsilon_j \sim \text{N}(0, \omega^2),}

and when it is used with an interaction,

\deqn{\beta_{u,v} = \phi_1 \beta_{u,v-1} + \cdots + \phi_n \beta_{u,v-n} + \epsilon_{u,v}}
\deqn{\epsilon_{u,v} \sim \text{N}(0, \omega^2),}

where
\itemize{
\item \eqn{\pmb{\beta}} is the main effect or interaction;
\item \eqn{j} denotes position within the main effect;
\item \eqn{v} denotes position within the "along" variable of the interaction;
\item \eqn{u} denotes position within the "by" variable(s) of the interaction; and
\item \eqn{n} is \code{n_coef}.
}

Internally, \code{AR()} derives a value for \eqn{\omega} that
gives every element of \eqn{\beta} a marginal
variance of \eqn{\tau^2}. Parameter \eqn{\tau}
has a half-normal prior

\deqn{\tau \sim \text{N}^+(0, \text{s}^2),}

where \code{s} is provided by the user.

The autocorrelation coefficients \eqn{\phi_1, \cdots, \phi_n}
are restricted to values between -1 and 1 that jointly
lead to a stationary model. The quantity
\eqn{r = \sqrt{\phi_1^2 + \cdots + \phi_n^2}} has the
boundary-avoiding prior

\deqn{r \sim \text{Beta}(2, 2).}
}

\examples{
AR(n_coef = 3)
AR(n_coef = 3, s = 2.4)
AR(along = "cohort")
}
\references{
\itemize{
\item \code{AR()} is based on the TMB function
\href{http://kaskr.github.io/adcomp/classdensity_1_1ARk__t.html#details}{ARk}
}
}
\seealso{
\itemize{
\item \code{\link[=AR1]{AR1()}} Special case of \code{AR()}
\item \code{\link[=Lin_AR]{Lin_AR()}}, \code{\link[=Lin_AR1]{Lin_AR1()}} Straight line with AR errors
\item \link{priors} Overview of priors implemented in \strong{bage}
\item \code{\link[=set_prior]{set_prior()}} Specify prior for intercept,
main effect, or interaction
}
}
