% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bag_tree.R
\name{bag_tree}
\alias{bag_tree}
\alias{update.bag_tree}
\title{General Interface for Bagged Decision Tree Models}
\usage{
bag_tree(
  mode = "unknown",
  cost_complexity = 0,
  tree_depth = NULL,
  min_n = 2,
  class_cost = NULL
)

\method{update}{bag_tree}(
  object,
  parameters = NULL,
  cost_complexity = NULL,
  tree_depth = NULL,
  min_n = NULL,
  class_cost = NULL,
  fresh = FALSE,
  ...
)
}
\arguments{
\item{mode}{A single character string for the type of model.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{cost_complexity}{A positive number for the the cost/complexity
parameter (a.k.a. \code{Cp}) used by CART models (\code{rpart} only).}

\item{tree_depth}{An integer for maximum depth of the tree.}

\item{min_n}{An integer for the minimum number of data points
in a node that are required for the node to be split further.}

\item{class_cost}{A non-negative scalar for a class cost (where a cost of 1
means no extra cost). This is useful for when the first level of the outcome
factor is the minority class. If this is not the case, values between zero
and one can be used to bias to the second level of the factor.}

\item{object}{A bagged tree model specification.}

\item{parameters}{A 1-row tibble or named list with \emph{main}
parameters to update. If the individual arguments are used,
these will supersede the values in \code{parameters}. Also, using
engine arguments in this object will result in an error.}

\item{fresh}{A logical for whether the arguments should be
modified in-place of or replaced wholesale.}

\item{...}{Not used for \code{update()}.}
}
\description{
\code{bag_tree()} is a way to generate a \emph{specification} of a model
before fitting and allows the model to be created using
different packages in R. The main arguments for the
model are:
\itemize{
\item \code{cost_complexity}: The cost/complexity parameter (a.k.a. \code{Cp})
used by CART models (\code{rpart} only).
\item \code{tree_depth}: The \emph{maximum} depth of a tree (\code{rpart}).
\item \code{min_n}: The minimum number of data points in a node
that are required for the node to be split further.
\item \code{class_cost}: A cost value to asign to the class corresponding to the
first factor level (for 2-class models, \code{rpart} and \code{C5.0} only).
}
These arguments are converted to their specific names at the
time that the model is fit. Other options and argument can be
set using \code{set_engine()}. If left to their defaults
here (\code{NULL}), the values are taken from the underlying model
functions. If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\details{
The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item \pkg{R}:  \code{"rpart"} (the default) or \code{"C5.0"} (classification only)
}

Note that, for \code{rpart} models, but \code{cost_complexity} and
\code{tree_depth} can be both be specified but the package will give
precedence to \code{cost_complexity}. Also, \code{tree_depth} values
greater than 30 \code{rpart} will give nonsense results on 32-bit
machines.
}
\examples{
library(parsnip)

set.seed(9952)
bag_tree(tree_depth = 5) \%>\%
  set_mode("classification") \%>\%
  set_engine("rpart", times = 3) \%>\%
  fit(Species ~ ., data = iris)


model <- bag_tree(cost_complexity = 10, min_n = 3)
model
update(model, cost_complexity = 1)
update(model, cost_complexity = 1, fresh = TRUE)
}
