% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cB_small_data.R
\docType{data}
\name{cB_small}
\alias{cB_small}
\title{Example cB data frame}
\format{
A dataframe with 5788 rows and 5 variables; each row corresponds to a group of sequencing reads
\describe{
\item{sample}{Sample name}
\item{TC}{Number of T-to-C mutations}
\item{nT}{Number of Ts}
\item{XF}{Name of feature to which the group of reads map; usually a gene name}
\item{n}{Number of identical sequencing reads}
}
}
\usage{
data(cB_small)
}
\description{
Subset of a cB file from the DCP2 dataset published in Luo et al. 2020.
The original file is large (69 MB), so the example cB file has been
downsampled and contains only 10 genes (rather than 25012). The columns
are described in the Getting_Started vignette.
}
\examples{
data(cB_small)
data(metadf)
bakRdat <- bakRData(cB_small, metadf)
}
\references{
Luo et al. (2020) Biochemistry. 59(42), 4121-4142
}
\keyword{cB_small}
