% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Visualizations.R
\name{plotMA}
\alias{plotMA}
\title{Creating L2FC(kdeg) MA plot from fit objects}
\usage{
plotMA(
  obj,
  Model = c("MLE", "Hybrid", "MCMC"),
  FDR = 0.05,
  Exps = NULL,
  Exp_shape = FALSE
)
}
\arguments{
\item{obj}{Object of class bakRFit outputted by \code{bakRFit} function}

\item{Model}{String identifying implementation for which you want to generate an MA plot}

\item{FDR}{False discovery rate to control at for significance assessment}

\item{Exps}{Vector of Experimental IDs to include in plot; must only contain elements within 2:(# of experimental IDs)}

\item{Exp_shape}{Logical indicating whether to use Experimental ID as factor determining point shape in volcano plot}
}
\value{
A ggplot object. Each point represents a transcript. The
x-axis is log-10 transformed replicate average read counts,
y-axis is the log-2 fold-change in the degradation rate constant.
}
\description{
This function outputs a L2FC(kdeg) MA plot. Plots are colored according to statistical
significance and the sign of L2FC(kdeg)
}
\examples{
\donttest{
# Simulate data for 500 genes and 2 replicates
sim <- Simulate_bakRData(500, nreps = 2)

# Fit data with fast implementation
Fit <- bakRFit(sim$bakRData)

# Volcano plot
plotMA(Fit, Model = "MLE")

}
}
