% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bakRData.R
\name{bakRFnData}
\alias{bakRFnData}
\title{bakRFnData object helper function for users}
\usage{
bakRFnData(fns, metadf)
}
\arguments{
\item{fns}{Dataframe with columns corresponding to sample names (sample), feature IDs (XF),
fraction new estimates (fn), and number of sequencing reads (nreads). \code{fns} can optionally
contain a column of fraction new estimate uncertainties (se).}

\item{metadf}{Dataframe detailing s4U label time and experimental ID of each sample. Identical to \code{bakRData}
input}
}
\value{
A bakRFnData object. This has two components: a data frame describing experimental
details (metadf) and a data frame containing the fraction new estimates (fns).
}
\description{
This function creates an object of class bakRFnData
}
\examples{
### NEED TO ADD EXAMPLE DATA
# Load cB
data("cB_small")

# Load metadf
data("metadf")

# Create bakRData object
bakRData <- bakRData(cB_small, metadf)

}
