% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_bakerrr.R
\name{bakerrr}
\alias{bakerrr}
\title{S7 bakerrr class for job orchestration and background processing}
\usage{
bakerrr(
  fun,
  args_list,
  bg_args = list(),
  n_daemons = ceiling(parallel::detectCores()/5),
  cleanup = TRUE
)
}
\arguments{
\item{fun}{Function to be executed for each job.}

\item{args_list}{List of argument sets for each job.}

\item{bg_args}{List of arguments passed to background job handler.}

\item{n_daemons}{Number of parallel workers (default: ceiling of cores/5).}

\item{cleanup}{Logical; whether to clean up jobs after
execution (default: TRUE).}
}
\value{
An S7 bakerrr class object with job orchestration
methods and properties.
}
\description{
Defines the \code{bakerrr} S7 class for parallel and
background job execution.
Stores the function to run (\code{fun}),
argument lists (\code{args_list}),
background job arguments (\code{bg_args}),
job objects, results, and runtime properties.
Supports retrieval of job status/results and
validation of provided properties.
}
\examples{
# Create a bakerrr object to process jobs in parallel
bakerrr::bakerrr(fun = sum, args_list = list(list(1:10), list(10:20)))

}
