% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbp.R
\name{sbp.fromPropd}
\alias{sbp.fromPropd}
\title{Build SBP Matrix of "Anti-Balances"}
\usage{
sbp.fromPropd(x, group, ...)
}
\arguments{
\item{x}{A matrix with rows as samples (N) and columns as components (D).}

\item{group}{A character vector. Group or sub-group membership.
Argument passed to \code{propr::propd}.}

\item{...}{Other arguments passed to \code{propr::propd}.}
}
\value{
An SBP matrix.
}
\description{
This function builds an SBP of "anti-balances" by clustering
 the difference of the log-ratio variance from the
 maximum log-ratio variance. Unlike principal balances,
 where the first balances explain the most variance,
 this function selects "anti-balances" so that the
 last balances explain the most variance.
}
\examples{
\dontrun{
library(balance)
data(iris)
x <- iris[,1:4]
sbp.fromPropd(x)
}

}
\author{
Thom Quinn
}
