% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base64.R
\name{base64}
\alias{base64}
\alias{encode}
\alias{decode}
\title{Encode and Decode base64}
\usage{
encode(input, output = tempfile(), linebreaks = TRUE)

decode(input, output = tempfile())
}
\arguments{
\item{input}{input file}

\item{output}{output file}

\item{linebreaks}{insert linebreaks to make output human readable
See \link[openssl:base64_encode]{openssl::base64_encode}}
}
\description{
Wrapper for \link[openssl:base64_encode]{openssl::base64_encode}.
}
\examples{
# encode a file
myfile <- R.home("COPYING")
tmp <- tempfile()
base64::encode(myfile, tmp)

# decode it back
orig <- tempfile()
base64::decode(tmp, orig)
readLines(orig)
}
