% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model_formula_tools.R
\name{build_model_formula}
\alias{build_model_formula}
\title{Build formula for statistical models}
\usage{
build_model_formula(
  outcome,
  predictors,
  censor_event = NULL,
  env = parent.frame()
)
}
\arguments{
\item{outcome}{character denoting the column with the outcome.}

\item{predictors}{vector of characters denoting the columns with the
predictors.}

\item{censor_event}{character denoting the column with the censoring event,
for use in Survival-type models.}

\item{env}{environment to be used in formula creation}
}
\value{
formula for use in statistical models
}
\description{
Build formula used in statistical models from vectors of strings with the option to specify an environment.
}
\examples{
build_model_formula("outcome", c("pred_1", "pred_2"))
build_model_formula("outcome", c("pred_1", "pred_2"), censor_event = "cens_event")

}
\author{
J. Peter Marquardt
}
