% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trendline.R
\name{trendline}
\alias{trendline}
\title{Add Trendline and Show Equation to Plot}
\usage{
trendline(x, y, model = "line2P", plot = TRUE, linecolor = "red",
  lty = 1, lwd = 1, summary = TRUE, ePos = "topleft", eDigit = 5,
  eSize = 1)
}
\arguments{
\item{x, y}{the x and y arguments provide the x and y coordinates for the plot. Any reasonable way of defining the coordinates is acceptable.}

\item{model}{select which model to fit. Default is "line2P". The "model" should be one of c("line2P", "line3P", "log2P", "exp3P", "power3P"), their formulas are as follows:\cr "line2P": y=a*x+b \cr "line3P": y=a*x^2+b*x+c \cr "log2P": y=a*ln(x)+b \cr "exp3P": y=a*exp(b*x)+c \cr "power3P": y=a*x^b+c}

\item{plot}{draw a scatter plot automatically, the vlaue is one of c("TRUE", "FALSE").}

\item{linecolor}{color of regression line.}

\item{lty}{line type. lty can be specified using either text c("blank","solid","dashed","dotted","dotdash","longdash","twodash") or number c(0, 1, 2, 3, 4, 5, 6). Note that lty = "solid" is identical to lty=1.}

\item{lwd}{line width. Default is 1.}

\item{summary}{summarizing the model fits. Default is TRUE.}

\item{ePos}{equation position, such as one of c("none","bottomright","bottom","bottomleft","left","topleft","top","topright","right","center").}

\item{eDigit}{the numbers of digits for equation parameters. Default is 5.}

\item{eSize}{font size in percentage of equation. Default is 1.}
}
\value{
R^2, indicates the R-Squared value of each regression model.

p, indicates the p-value of each regression model.

AIC or BIC, indicate the Akaike's Information Criterion or Bayesian Information Criterion for fitted model. Click \code{\link[stats]{AIC}} for details. The smaller the AIC or BIC, the better the model.
}
\description{
Plot and show both regression line and equation as simple as possible,
by using different models built in the 'trendline()' function. The function includes the following models in the latest version:
"line2P" (formula as: y=a*x+b), "line3P" (y=a*x^2+b*x+c), "log2P" (y=a*ln(x)+b), "exp3P" (y=a*exp(b*x)+c), and "power3P" (y=a*x^b+c).
Besides, the summarized results of each fitted model are also output by default.
}
\examples{
library(basicTrendline)
x1<-1:5
x2<- -2:2
x3<- c(101,105,140,200,660)
x4<- -5:-1
x5<- c(1,30,90,180,360)

y1<-c(2,14,18,19,20)        # increasing convex trend
y2<- c(-2,-14,-18,-19,-20)  # decreasing concave trend
y3<-c(2,4,16,38,89)         # increasing concave trend
y4<-c(-2,-4,-16,-38,-89)    # decreasing convex trend
y5<- c(600002,600014,600018,600019,600020) # high y values with low range.

trendline(x1,y1,model="line2P",summary=TRUE,eDigit=10)
trendline(x2,y2,model="line3P",summary=FALSE,ePos="topright")
trendline(x3,y3,model="log2P",linecolor="blue")
trendline(x4,y4,model="exp3P",eSize=0.7) #change the font size of equation.
trendline(x5,y5,model="power3P")

## Not run
plot(x1,y1,main="Different regression lines in one plot")
library(basicTrendline)
trendline(x1,y1,model="line2P",plot=FALSE,ePos="none",linecolor="red")
trendline(x1,y1,model="log2P",plot=FALSE,ePos="none",linecolor="blue",lty=2)
trendline(x1,y1,model="exp3P",plot=FALSE,ePos="none",linecolor="black",lty=3)
legend("bottomright",c("line2P","log2P","exp3P"), lty=c(1,2,3),col=c("red","blue","black"))
## END (Not run)

}
\seealso{
\code{\link{trendline}}, \code{\link{SSexp3P}}, \code{\link{SSpower3P}}, \code{\link[stats]{nls}}, \code{\link[stats]{selfStart}}
}
\author{
Weiping Mei, Guangchuang Yu
}
