% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extr_mkt_events.R
\docType{data}
\name{extr_mkt_events}
\alias{extr_mkt_events}
\title{Extreme market events dataset}
\format{
A multivariate time series of class \link[stats]{ts}.
}
\source{
Zambon, L., Agosto, A., Giudici, P., Corani, G. (2023). \emph{Properties of the reconciled distributions for Gaussian and count forecasts}. \doi{10.48550/arXiv.2303.15135}.
}
\usage{
extr_mkt_events
}
\description{
Count time series of extreme market events in five economic sectors.
The data refer to the trading days between 2004/12/31 and 2018/12/19 (3508 trading days in total).
}
\details{
The counts are computed by considering 29 companies included in the Euro Stoxx
50 index and observing if the value of the CDS spread on a given day exceeds
the 90-th percentile of its distribution in the last trading year.
The companies are divided in the following  sectors: Financial (FIN), Information
and Communication Technology (ICT), Manufacturing (MFG), Energy (ENG), and Trade (TRD).

There are 6 time series:
\itemize{
\item 5 bottom time series, corresponding to the daily counts for each sector
\item 1 upper time series, which is the sum of all the bottom (ALL)
}
}
\references{
Zambon, L., Agosto, A., Giudici, P., Corani, G. (2023). \emph{Properties of the reconciled distributions for Gaussian and count forecasts}. \doi{10.48550/arXiv.2303.15135}.

Agosto, A. (2022). \emph{Multivariate Score-Driven Models for Count Time Series to Assess Financial Contagion}. \doi{10.2139/ssrn.4119895}
}
\keyword{datasets}
