% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_sarima.R
\name{fourier}
\alias{fourier}
\title{Fourier terms for modeling seasonality.}
\usage{
fourier(x, K, h = NULL)
}
\arguments{
\item{x}{Seasonal time series: a \code{ts} or a \code{msts} object}

\item{K}{Maximum order(s) of Fourier terms}

\item{h}{Number of periods ahead to forecast (optional)}
}
\value{
Numerical matrix.
}
\description{
\code{fourier} returns a matrix containing terms from a Fourier series, up
to order \code{K}, suitable for use in \code{\link{Sarima}} or
\code{\link{auto.sarima}}.
}
\details{
The period of the Fourier terms is determined from the time series
characteristics of \code{x}. When \code{h} is missing, the length of
\code{x} also determines the number of rows for the matrix returned by
\code{fourier}. Otherwise, the value of \code{h} determines the number of
rows for the matrix returned by \code{fourier}, typically used for
forecasting. The values within \code{x} are not used.

Typical use would omit \code{h} when generating Fourier terms fitting a model
and include \code{h} when generating Fourier terms for forecasting.

When \code{x} is a \code{ts} object, the value of \code{K} should be an
integer and specifies the number of sine and cosine terms to return. Thus,
the matrix returned has \code{2*K} columns.

When \code{x} is a \code{msts} object, then \code{K} should be a vector of
integers specifying the number of sine and cosine terms for each of the
seasonal periods. Then the matrix returned will have \code{2*sum(K)}
columns.
}
\examples{
\donttest{
 library(astsa)
 # Dynaimc Harmonic regression
 sf1 = auto.sarima(birth,xreg = fourier(birth,K= 6))
}

}
\seealso{
\code{\link{seasonaldummy}}
}
\author{
Rob J Hyndman
}
\keyword{forecast}
