% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast.R
\name{forecast.varstan}
\alias{forecast.varstan}
\alias{forecast}
\title{Forecasting varstan objects}
\usage{
\method{forecast}{varstan}(
  object,
  h = 10,
  probs = c(0.8, 0.9),
  xreg = NULL,
  robust = FALSE,
  draws = 1000,
  seed = NULL,
  ...
)
}
\arguments{
\item{object}{a time series or varstan model for which forecasts are
required.}

\item{h}{Number of periods for forecasting.}

\item{probs}{A numerical vector \eqn{p \in (0,1)}{p (0 < p < 1)} indicating the desired
probability mass to include in the intervals. The default is to report
\code{90\%} and \code{80\%} intervals (\code{level=c(0.8,0.9)}).}

\item{xreg}{Optionally, a numerical matrix of external regressors,
which must have the same number of rows as ts. It should not be a data frame.}

\item{robust}{A boolean for obtain the robust estimation. The default}

\item{draws}{An integer indicating the number of draws to return. The default
number of draws is 1000.}

\item{seed}{An optional \code{\link[=set.seed]{seed}} to use.}

\item{...}{Further arguments passed to  \code{posterior_predict}.}
}
\value{
An object of class "\code{forecast}".

The function \code{summary} is used to obtain and print a summary of the
results, while the function \code{plot} produces a plot of the forecasts and
prediction intervals.

The generic accessors functions \code{fitted.values} and \code{residuals}
extract various useful features of the value returned by
\code{forecast$model}.

An object of class \code{"forecast"} is a list usually containing at least
the following elements: \item{model}{A list containing information about the
fitted model} \item{method}{The name of the forecasting method as a
character string} \item{mean}{Point forecasts as a time series}
\item{lower}{Lower limits for prediction intervals} \item{upper}{Upper
limits for prediction intervals} \item{level}{The confidence values
associated with the prediction intervals} \item{x}{The original time series
(either \code{object} itself or the time series used to create the model
stored as \code{object}).} \item{residuals}{Residuals from the fitted model.
For models with additive errors, the residuals will be x minus the fitted
values.} \item{fitted}{Fitted values (one-step forecasts)}
}
\description{
\code{forecast} is a generic function for forecasting from time series or
varstan models. The function invokes particular \emph{methods} which
depend on the class of the first argument.
}
\details{
If \code{model=NULL},the function \code{\link{forecast.ts}} makes forecasts
using \code{\link{ets}} models (if the data are non-seasonal or the seasonal
period is 12 or less) or \code{\link{stlf}} (if the seasonal period is 13 or
more).

If \code{model} is not \code{NULL}, \code{forecast.ts} will apply the
\code{model} to the \code{object} time series, and then generate forecasts
accordingly.
}
\examples{
\donttest{
 fit = auto.sarima(ts = birth,iter = 500,chains = 1)
 fc = forecast(fit,h = 12)
}

}
\seealso{
The \code{"forecast"} methods of the forecast package.
}
\author{
Asael Alonzo Matamoros.
}
