% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhdior.R
\name{mhdior}
\alias{mhdior}
\alias{mhdior.numeric}
\alias{mhdior.data.frame}
\alias{mhdior.emmGrid}
\alias{mhdior.BFBayesFactor}
\alias{mhdior.stanreg}
\alias{mhdior.brmsfit}
\title{Maximum HDI level inside/outside ROPE (MHDIOR)}
\usage{
mhdior(x, ...)

\method{mhdior}{numeric}(x, range = "default", precision = 0.1, ...)

\method{mhdior}{data.frame}(x, range = "default", precision = 0.1, ...)

\method{mhdior}{emmGrid}(x, range = "default", precision = 0.1, ...)

\method{mhdior}{BFBayesFactor}(x, range = "default", precision = 0.1, ...)

\method{mhdior}{stanreg}(
  x,
  range = "default",
  precision = 0.1,
  effects = c("fixed", "random", "all"),
  parameters = NULL,
  ...
)

\method{mhdior}{brmsfit}(
  x,
  range = "default",
  precision = 0.1,
  effects = c("fixed", "random", "all"),
  component = c("conditional", "zi", "zero_inflated", "all"),
  parameters = NULL,
  ...
)
}
\arguments{
\item{x}{Vector representing a posterior distribution. Can also be a \code{stanreg} or \code{brmsfit} model.}

\item{...}{Currently not used.}

\item{range}{ROPE's lower and higher bounds. Should be a vector of length two (e.g., \code{c(-0.1, 0.1)}) or \code{"default"}. If \code{"default"}, the range is set to \code{c(-0.1, 0.1)} if input is a vector, and based on \code{\link[=rope_range]{rope_range()}} if a Bayesian model is provided.}

\item{precision}{The precision by which to explore the ROPE space (in percentage). Lower values increase the precision of the returned p value but can be quite computationaly costly.}

\item{effects}{Should results for fixed effects, random effects or both be returned?
Only applies to mixed models. May be abbreviated.}

\item{parameters}{Regular expression pattern that describes the parameters that
should be returned. Meta-parameters (like \code{lp__} or \code{prior_}) are
filtered by default, so only parameters that typically appear in the
\code{summary()} are returned. Use \code{parameters} to select specific parameters
for the output.}

\item{component}{Should results for all parameters, parameters for the conditional model
or the zero-inflated part of the model be returned? May be abbreviated. Only
applies to \pkg{brms}-models.}
}
\description{
The MHDIOR (pronounced 'em-eich-dior') is an exploratory and non-validated index representing the maximum percentage of \link[=hdi]{HDI} that does not contain (or is entirely contained, in which case the value is prefixed with a negative sign), in the negligible values space defined by the \link[=rope]{ROPE}. It differs from the ROPE percentage, \emph{i.e.}, from the proportion of a given CI in the ROPE, as it represents the maximum CI values needed to reach a ROPE proportion of 0\% or 100\%. Whether the index reflects the ROPE reaching 0\% or 100\% is indicated through the sign: a negative sign is added to indicate that the probability corresponds to the probability of a not significant effect (a percentage in ROPE of 100\%). For instance, a MHDIOR of 97\% means that there is a probability of .97 that a parameter (described by its posterior distribution) is outside the ROPE. In other words, the 97\% HDI is the maximum HDI level for which the percentage in ROPE is 0\%. On the contrary, a ROPE-based p of -97\% indicates that there is a probability of .97 that the parameter is inside the ROPE (percentage in ROPE of 100\%). A value close to 0\% would indicate that the mode of the distribution falls perfectly at the edge of the ROPE, in which case the percentage of HDI needed to be on either side of the ROPE becomes infinitely small. Negative values do not refer to negative values \emph{per se}, simply indicating that the value corresponds to non-significance rather than significance.
}
\examples{
library(bayestestR)

# precision = 1 is used to speed up examples...

mhdior(
  x = rnorm(1000, mean = 1, sd = 1),
  range = c(-0.1, 0.1),
  precision = 1
)

df <- data.frame(replicate(4, rnorm(100)))
mhdior(df, precision = 1)

library(rstanarm)
model <- stan_glm(mpg ~ wt + gear, data = mtcars, chains = 2, iter = 200, refresh = 0)
mhdior(model, precision = 1)

library(emmeans)
mhdior(emtrends(model, ~1, "wt"))
\dontrun{
library(brms)
model <- brms::brm(mpg ~ wt + cyl, data = mtcars)
mhdior(model)

library(BayesFactor)
bf <- ttestBF(x = rnorm(100, 1, 1))
mhdior(bf)
}

}
