% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unupdate.R
\name{unupdate}
\alias{unupdate}
\alias{unupdate.stanreg}
\alias{unupdate.brmsfit}
\title{Un-update Bayesian models to their prior-to-data state}
\usage{
unupdate(model, verbose = TRUE)

\method{unupdate}{stanreg}(model, verbose = TRUE)

\method{unupdate}{brmsfit}(model, verbose = TRUE)
}
\arguments{
\item{model}{A fitted Bayesian model.}

\item{verbose}{Toggle warnings.}
}
\value{
A model un-fitted to the data, representing the prior model.
}
\description{
As posteriors are priors that have been updated after observing some data,
the goal of this function is to un-update the posteriors to obtain models
representing the priors. These models can then be used to examine the prior
predictive distribution, or to compare priors with posteriors.
\cr\cr
This function in used internally to compute Bayes factors.
}
\keyword{internal}
