% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayou-utilities.R
\name{bayou.checkModel}
\alias{bayou.checkModel}
\title{Function for checking parameter lists, prior and models are consistent and error-free}
\usage{
bayou.checkModel(
  pars = NULL,
  tree,
  dat,
  pred = NULL,
  SE = 0,
  prior,
  model = "OU",
  autofix = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{pars}{A list of parameters that will be specified as starting parameter}

\item{tree}{An object of class ``phylo''}

\item{dat}{A named data vector that matches the tip lables in the provided tree}

\item{pred}{A matrix or data frame with named columns with predictor data represented
in the specified formula}

\item{SE}{The standard error of the data. Either a single value applied to all the data,
or a vector of length(dat).}

\item{prior}{A prior function made using make.prior}

\item{model}{Either one of c("OU", "QG" or "OUrepar") or a list specifying the model
to be used.}

\item{autofix}{A logical that indicates whether certain errors should be automatically fixed.}

\item{verbose}{Determines whether information is outputted to the console for the user to view}
}
\value{
A list of results of the checks and if 'autofix==TRUE', then ..$autofixed returns a
list of all the input elements, with corrections.
}
\description{
Function for checking parameter lists, prior and models are consistent and error-free
}
\details{
A series of checks are performed, run internally within bayou.makeMCMC, but can also
be run on provided inputs prior to this. Errors are reported.

If autofix == TRUE, then the following errors will be automatically corrected:

Branch lengths == 0; any branches of length 0 will be given length .Machine$double.eps
is.binary(tree) == FALSE; runs multi2di
pars do not match prior$fixed; parameters are resimulated from prior
}
