% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrGraphs_linearPretty.R
\name{linearPretty}
\alias{linearPretty}
\title{Pretty Axis}
\usage{
linearPretty(
  x,
  hard = FALSE,
  labels = "Auto",
  style = "Auto",
  extend.pct = 0,
  extend.range = TRUE
)
}
\arguments{
\item{x}{data defining the range to be plotted on the axis. Missing values
are permitted, but ignored.}

\item{hard}{logical, if \code{TRUE}, then use the minimum and maximum of 
\code{x} as the fixed range of the axis, otherwise find "nice" limits.}

\item{labels}{either "Auto," which lets the function decide how many labels,
the approximate number of labels, or the actual labels to use. If the actual
labels are numeric, then the will be formatted using \code{style}. If they are
character, then they must be able to be converted to numeric values (commas
are removed before conversion).}

\item{style}{a character string indicating the style of the axis labels if
they are not specifically listed in \code{labels}. Valid values are "numeric,"
which forces the labels to be displayed as numbers; "scientific," which forces
the labels displayed using scientific notation; or "Auto" (the default), which
disaplays labels as numbers but switches to scientific notation for large ranges.
Only the first letter is required. Any invalid value will produce simply formatted
labels.}

\item{extend.pct}{extend the axis range by \code{extend.pct}. Only valid
when \code{hard} is FALSE.}

\item{extend.range}{if \code{TRUE}, then extend the data range by a bit to
avoid plotting on axis. Otherwise do not extend the data range. Only valid
when \code{hard} is FALSE; Ignored in \code{logPretty}}
}
\value{
Information about the axis labels.
}
\description{
Constructs information for making a nicely formatted linear numeric axis.
A support function for creating linear axes.
}
\details{
Added from smwrGraphs.
}
\keyword{dplot}
\keyword{internal}
