% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.fun.R
\name{as.fun}
\alias{as.fun}
\alias{as.fun.default}
\alias{as.fun.character}
\alias{as.fun.name}
\alias{as.fun.numeric}
\alias{as.fun.logical}
\alias{as.fun.factor}
\alias{as.fun.complex}
\alias{as.fun.data.frame}
\title{Convert object to function}
\usage{
as.fun(x, ...)

\method{as.fun}{default}(x, envir = parent.frame(), ...)

\method{as.fun}{character}(x, ...)

\method{as.fun}{name}(x, ...)

\method{as.fun}{numeric}(x, ...)

\method{as.fun}{logical}(x, ...)

\method{as.fun}{factor}(x, ...)

\method{as.fun}{complex}(x, ...)

\method{as.fun}{data.frame}(x, ...)
}
\arguments{
\item{x}{The object to convert.}

\item{...}{Additional arguments, not used currently.}

\item{envir}{Environment in which the function should be defined.}
}
\value{
The desired function.
}
\description{
\code{as.fun} is a generic function that does the same as \code{as.function} 
from package \pkg{base}, with the additional feature that 
\code{as.fun.character} converts a string into the function it names.
}
\examples{
as.fun(mean)
as.fun("mean")
as.fun("edit")
as.fun("stats::predict")

f <- as.fun(1)
f(2)   # 1
f("a") # 1

f <- as.fun(FALSE)
f(2)   # FALSE
f("a") # FALSE

f <- as.fun(data.frame(x = 1:2, y = 2:3))
f("x") # 'x' column
f("y") # 'y' column

}
\author{
Adapted from MrFlick, 
see \url{https://stackoverflow.com/a/38984214} on StackOverflow.
}
