% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{sufficientStatistics.DP}
\alias{sufficientStatistics.DP}
\title{Sufficient statistics of a "DP" object}
\usage{
\method{sufficientStatistics}{DP}(obj, x, ...)
}
\arguments{
\item{obj}{A "DP" object.}

\item{x}{Random samples of the "BasicBayesian" object.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
Return the sufficient statistics of the corresponding BasicBayesian type, see examples.
}
\description{
For following model structure: \cr
Create an object of type "DP", which represents the Dirichlet-Process model structure: \cr
     pi|alpha ~ DP(alpha,U) \cr
     z|pi ~ Categorical(pi) \cr
     theta_z|psi ~ H0(psi) \cr
     x|theta_z,z ~ F(theta_z) \cr
where DP(alpha,U) is a Dirichlet Process on positive integers, alpha is the "concentration parameter" of the Dirichlet Process, U is the "base measure" of this Dirichlet process. The choice of F() and H0() can be arbitrary, they are distributions of x and theta_z correspondingly. \cr
The sufficient statistics of a set of samples x in a "DP" object is the same sufficient statistics of the "BasicBayesian" inside the "DP", see examples.
}
\examples{
obj1 <- DP(gamma=list(alpha=1,H0aF="GaussianNIW",parH0=list(m=1,k=1,v=1,S=1)))
obj2 <- DP(gamma=list(alpha=1,H0aF="CatDirichlet",parH0=list(alpha=1,uniqueLabels=letters)))
x1 <- rnorm(100)
x2 <- sample(letters,100,replace = TRUE)
sufficientStatistics(obj = obj1,x=x1)
sufficientStatistics(obj = obj2,x=x2)
sufficientStatistics(obj = obj1,x=x1,foreach = TRUE)
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{DP}}, \code{\link{sufficientStatistics_Weighted.DP}}
}
