% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbsBayes-deprecated.R,
%   R/generate-cont-indices.R, R/generate-cont-trend.R,
%   R/generate-regional-indices.R, R/generate-regional-trends.R,
%   R/generate-strata-indices.R, R/generate-strata-trends.R, R/p-waic.R,
%   R/plot-cont-indices.R, R/prepare-jags-data.R, R/waic.R
\name{bbsBayes-deprecated}
\alias{bbsBayes-deprecated}
\alias{generate_cont_indices}
\alias{generate_cont_trend}
\alias{generate_regional_indices}
\alias{generate_regional_trends}
\alias{generate_strata_indices}
\alias{generate_strata_trends}
\alias{p_waic}
\alias{plot_cont_indices}
\alias{prepare_jags_data}
\alias{waic}
\title{Deprecated functions in package \pkg{bbsBayes}.}
\usage{
generate_cont_indices(
  jags_mod = NULL,
  quantiles = c(0.025, 0.05, 0.25, 0.75, 0.95, 0.975),
  alternate_n = "n"
)

generate_cont_trend(
  indices = NULL,
  min_year = NULL,
  max_year = NULL,
  quantiles = c(0.025, 0.05, 0.25, 0.75, 0.95, 0.975),
  slope = FALSE
)

generate_regional_indices(
  jags_mod = NULL,
  jags_data = NULL,
  quantiles = c(0.025, 0.05, 0.25, 0.75, 0.95, 0.975),
  regions = c("stratum", "continental"),
  alternate_n = "n",
  startyear = NULL,
  drop_exclude = FALSE,
  max_backcast = NULL,
  alt_region_names = NULL
)

generate_regional_trends(
  indices = NULL,
  Min_year = NULL,
  Max_year = NULL,
  quantiles = c(0.025, 0.05, 0.25, 0.75, 0.95, 0.975),
  slope = FALSE,
  prob_decrease = NULL,
  prob_increase = NULL
)

generate_strata_indices(
  jags_mod = NULL,
  quantiles = c(0.025, 0.05, 0.25, 0.75, 0.95, 0.975),
  alternate_n = "n"
)

generate_strata_trends(
  indices = NULL,
  min_year = NULL,
  max_year = NULL,
  quantiles = c(0.025, 0.05, 0.25, 0.75, 0.95, 0.975),
  slope = FALSE
)

p_waic(jags_data = NULL, jags_mod = NULL, pointwise = FALSE)

plot_cont_indices(
  indices_list = NULL,
  select = FALSE,
  ci_width = 0.95,
  min_year = NULL,
  max_year = NULL,
  species = "",
  title_size = 20,
  axis_title_size = 18,
  axis_text_size = 16,
  add_observed_means = FALSE
)

prepare_jags_data(
  strat_data = NULL,
  species_to_run = NULL,
  model = NULL,
  heavy_tailed = FALSE,
  n_knots = NULL,
  min_year = NULL,
  max_year = NULL,
  min_n_routes = 3,
  min_max_route_years = 3,
  min_mean_route_years = 1,
  strata_rem = NULL,
  quiet = FALSE,
  ...
)

waic(jags_data = NULL, jags_mod = NULL)
}
\arguments{
\item{jags_mod}{JAGS list generated by \code{run_model}}

\item{quantiles}{vector of quantiles to be sampled from the posterior distribution Defaults to c(0.025,0.05,0.25,0.5,0.75,0.95,0.975)}

\item{alternate_n}{text string indicating the name of the alternative approach to calculating an annual index, Default is "n"}

\item{indices}{Stratum indices generated by \code{generate_strata_indices}}

\item{min_year}{Minimum year to keep in analysis}

\item{max_year}{Maximum year to keep in analysis}

\item{slope}{Logical, if TRUE, calculates an alternative trend metric, the slope of a log-linear regression through the annual indices. Default FALSE}

\item{jags_data}{Data prepared by \code{prepare_jags_data}, used
for input to the JAGS model}

\item{regions}{vector selcting regional compilation(s) to calculate. Default is "continental","stratum", options also include "national", "prov_state", "bcr", and "bcr_by_country" for the stratifications that include areas that align with those regions.}

\item{startyear}{Optional first year for which to calculate the annual indices if a trajectory for only the more recent portion of the time series is desired. This is probably most relevant if max_backcast is set and so trajectories for different time-periods could include a different subset of strata (i.e., strata removed)}

\item{drop_exclude}{logical indicating if the strata that exceed the max_backcast threshold should be excluded from the calculations, Default is FALSE (regions are flagged and listed but not dropped)}

\item{max_backcast}{an optional integer indicating the maximum number of years to backcast the stratum-level estimates before the first year in which the species was observed on any route in that stratum. 5 is used in the CWS national estimates. If the observed data in a given stratum do not include at least one non-zero observation of the species between the first year of the BBS and startyear+max_backcast, the stratum is flagged within the relevant regional summary. Default value, NULL ignores any backcasting limit (i.e., generates annual indices for the entire time series, regardless of when the species was first observed)}

\item{alt_region_names}{Optional dataframe indicating the strata to include in a custom spatial summary. Generate the basic dataframe structure with the \code{extract_strata_areas} function, then modify with an additional column indicating the strata to include in a custom spatial summary}

\item{Min_year}{Minimum year to calculate trends from (e.g., 1970). Default is NULL, in which case the trend is calculated from the first year of the time-series of the supplied annual_indices file}

\item{Max_year}{Maximum year to calculate trends to (e.g., 2018). Default is NULL, in which case the trend is calculated up to the last year of the time-series of the supplied annual_indices file}

\item{prob_decrease}{Optional vector of percent-change values to calculate the posterior probabilities that the population has decreased by at least this much (e.g., prob_decrease = c(50) would result in a calculation of the probability that the population has decreased by more than 50 percent over the period of the trend, i.e., less than half the population remains. Default is NULL, in which case no probability of decrease is calculated.}

\item{prob_increase}{Optional vector of percent-change values to calculate the posterior probabilities that the population has increased by at least this much (e.g., prob_increase = c(100) would result in a calculation of the probability that the population has incrased by more than 100 percent, i.e., doubled, over the period of the trend. Default is NULL, in which case no probability of increase is calculated.}

\item{pointwise}{If set to \code{TRUE}, a data frame is returned
that contains the pointwise LPPD for each count. Defaults
to \code{FALSE}}

\item{indices_list}{List of indices of annual abundance and other results produced by
\code{generate_cont_indices}}

\item{select}{logical flag to indicate if the continental data need to be selected out of an indices_list object that includes stratum, national, or other region-types. Default is FALSE}

\item{ci_width}{quantile to define the width of the plotted credible interval. Defaults to 0.95, lower = 0.025 and upper = 0.975}

\item{species}{Species name to be added onto the plot}

\item{title_size}{Specify font size of plot title. Defaults to 20}

\item{axis_title_size}{Specify font size of axis titles. Defaults to 18}

\item{axis_text_size}{Specify font size of axis text. Defaults to 16}

\item{add_observed_means}{Should the plot include points indicated the observed mean counts. Defaults to FALSE.  Note: scale of observed means and annual indices may not match due to imbalanced sampling among strata}

\item{strat_data}{Large list of stratified data returned by \code{stratify()}}

\item{species_to_run}{Character string of the English name of the species to run}

\item{model}{Character string of model to be used.
Options are "slope", "firstdiff", "gam", "gamye.}

\item{heavy_tailed}{Logical indicating whether the extra-Poisson error distribution should be modeled as a t-distribution, with heavier tails than the standard normal distribution. Default is currently FALSE, but recent results suggest users should strongly consider setting this to TRUE, even though it requires much longer convergence times}

\item{n_knots}{Number of knots to be used in GAM function}

\item{min_n_routes}{Minimum routes per strata where species has been observed.
Defaults to 3}

\item{min_max_route_years}{Minimum number of years with non-zero observations
of species on at least 1 route. Defaults to 3}

\item{min_mean_route_years}{Minimum average of years per route with the
species observed. Defaults to 1.}

\item{strata_rem}{Strata to remove from analysis. Defaults to NULL}

\item{quiet}{Should progress bars be suppressed?}

\item{...}{Additional arguments}
}
\value{
List of 6 objects:
  \item{data_summary}{dataframe with the following columns}
  \item{Year}{Year of particular index}
  \item{Region}{Region name}
  \item{Index}{Strata-weighted count index}
  \item{additional columns for each of the values in quantiles}{quantiles of the posterior distribution}
  \item{samples}{array of all samples from the posterior distribution}
  \item{area-weights}{data frame of the strata names and area weights used to calculate the continental estimates}
  \item{y_min}{first year used in the model, scale 1:length of time-series}
  \item{y_max}{last year used in the model, scale 1:length of time-series}
  \item{startyear}{first year used in the model, scale 1966:2018}

Numeric percentage of trend

List of 6 objects
  \item{data_summary}{dataframe with the following columns}
  \item{Year}{Year of particular index}
  \item{Region}{Region name}
  \item{Region_alt}{Long name for region}
  \item{Region_type}{Type of region including continental, national,Province_State,BCR, bcr_by_country, or stratum}
  \item{Strata_included}{Strata included in the annual index calculations}
  \item{Strata_excluded}{Strata potentially excluded from the annual index calculations because they have no observations of the species in the first part of the time series, see arguments max_backcast and startyear}
  \item{Index}{Strata-weighted count index}
  \item{additional columns for each of the values in quantiles}{quantiles of the posterior distribution}
  \item{obs_mean}{Mean of the observed annual counts of birds across all routes and all years. An alternative estimate of the average relative abundance of the species in the region and year. Differences between this and the annual indices are a function of the model. For composite regions (i.e., anything other than stratum-level estimates) this average count is calculated as an area-weighted average across all strata included}
  \item{nrts}{Number of BBS routes that contributed data for this species, region, and year}
  \item{nnzero}{Number of BBS routes on which this species was observed (i.e., count is > 0) in this region and year}
  \item{backcast_flag}{approximate annual average proportion of the covered species range that is free of extrapolated population trajectories. e.g., 1.0 = data cover full time-series, 0.75 = data cover 75 percent of time-series. Only calculated if max_backcast != NULL}

  \item{samples}{array of all samples from the posterior distribution}
  \item{area-weights}{data frame of the strata names and area weights used to calculate the continental estimates}
  \item{y_min}{first year used in the summary, scale 1:length of time-series}
  \item{y_max}{last year used in the summary, scale 1:length of time-series}
  \item{startyear}{first year used in the summary, scale 1966:2018}

Dataframe with one row for each region included in indices object, and columns including:
  \item{Start_year}{first year of the trend}
  \item{End_year}{last year of the trend}
  \item{Region}{short name of the region}
  \item{Region_alt}{Long name for region}
  \item{Region_type}{Type of region including continental, national,Province_State,BCR, bcr_by_national, or stratum}
  \item{Strata_included}{Strata included in the trend and annual index calculations}
  \item{Strata_excluded}{Strata potentially excluded from the trend and annual index calculations because they have no observations of the species in the first part of the time series}
  \item{Trend}{Estimated mean annual percent change over the trend time-period (i.e., Start_year - End_year), according to an endpoint comparison of annual index in Start_year and the annual index in End_year}
  \item{Trend_Q_quantiles}{quantiles of the posterior distribution of Trend estimates, matching levels included in the quantiles argument}
  \item{Percent_Change}{Estimated total percent change over the trend time-period}
  \item{Percent_Change_Q_quantiles}{quantiles of the posterior distribution of Percent Change estimates, matching levels included in the quantiles argument}
  \item{Slope_Trend}{Estimated mean annual percent change over the trend time-period, according to the slope of a linear regression through the log-transformed annual indices}
  \item{Slope_Trend_Q_quantiles}{quantiles of the posterior distribution of Percent Change estimates, matching levels included in the quantiles argument}
  \item{prob_decrease_X_percent}{proportion of the posterior distribution of Percent_Change that is below the percentage values supplied in prob_decrease}
  \item{prob_increase_X_percent}{proportion of the posterior distribution of Percent_Change that is above the percentage values supplied in prob_increase}
  \item{Relative_Abundance}{Mean of the annual index values across all years. An estimate of the average relative abundance of the species in the region. Can be interepreted as the predicted average count of the species in an average year on an average route by an average observer, for the years, routes, and observers in the existing data}
  \item{Observed_Relative_Abundance}{Mean of the observed annual counts of birds across all routes and all years. An alternative estimate of the average relative abundance of the species in the region. For composite regions (i.e., anything other than stratum-level estimates) this average count is calculated as an area-weighted average across all strata included}
  \item{Number_of_Strata}{The number of strata included in the region}
  \item{Width_of_X_percent_Credible_Interval}{Width (in percent/year) of the credible interval on the Trend calculation. Calculated for the widest credible interval requested in quantiles argument. Default is 95 percent CI (i.e., Trend_Q0.975 - Trend_Q0.025)}
  \item{Width_of_X_percent_Credible_Interval_Slope}{Width (in percent/year) of the credible interval on the Trend calculation for the slope-based trend. Calculated for the widest credible interval requested in quantiles argument. Default is 95 percent CI (i.e., Slope_Trend_Q0.975 - Slope_Trend_Q0.025)}
  \item{Number_of_Routes}{The number of unique BBS routes included in the trend calculation for this region and species}
  \item{Mean_Number_of_Routes}{The average number of BBS routes across years contributing data for this region and species}
  \item{backcast_flag}{approximate proportion of the included species range*years that are free of extrapolated population trajectories e.g., 1.0 = data cover full time-series, 0.75 = data cover 75 percent of time-series. Only calculated if max_backcast != NULL}

List of 6 objects:
  \item{data_summary}{dataframe with the following columns}
  \item{Year}{Year of particular index}
  \item{Region}{Region name}
  \item{Index}{Strata-weighted count index}
  \item{additional columns for each of the values in quantiles}{quantiles of the posterior distribution}

  \item{samples}{array of all samples from the posterior distribution}
  \item{area-weights}{data frame of the strata names and area weights used to calculate the continental estimates}
  \item{y_min}{first year used in the model, scale 1:length of time-series}
  \item{y_max}{last year used in the model, scale 1:length of time-series}
  \item{startyear}{first year used in the model, scale 1966:2018}

Data frame of 2 variables:
  \item{Stratum}{Name of the stratum}
  \item{Trend}{Percent change from the minimum year to maximum year}

Data frame of pointwise pWAIC by count if \code{pointwise}
  is set to \code{TRUE}. Double precision numerical value of pWAIC if
  \code{pointwise} is set to \code{FALSE}.

ggplot of continental indices

List of data to be used in JAGS, including:
  \item{model}{The model to be used in JAGS}
  \item{heavy_tailed}{Logical indicating whether the extra-Poisson error distribution should be modeled as a t-distribution}
  \item{min_nu}{if heavy_tailed is TRUE, minimum value for truncated gamma on DF of t-distribution noise default is 0 and user must change manually after function is run}
  \item{ncounts}{The number of counts containing useful data for the species}
  \item{nstrata}{The number of strata used in the analysis}
  \item{ymin}{Minimum year used}
  \item{ymax}{Maximum year used}
  \item{nonzeroweight}{Proportion of routes in each strata with species obervation}
  \item{count}{Vector of counts for the species}
  \item{strat}{Vector of strata to be used in the analysis}
  \item{obser}{Vector of unique observer-route pairings}
  \item{year}{Vector of years for each count}
  \item{firstyr}{Vector of indicator variables as to whether an observer was a first year}
  \item{month}{vector of numeric month of observation}
  \item{day}{vector of numeric day of observation}
  \item{nobservers}{Total number of observer-route pairings}
  \item{fixedyear}{Median of all years (ymin:ymax), included only with slope model}
  \item{nknots}{Number of knots to use for smooting functions, included only with GAM}
  \item{X.basis}{Basis function for n smoothing functions, included only with GAM}

Double precision numerical value
}
\description{
The functions listed below are deprecated and will be defunct in
  the near future. When possible, alternative functions with similar
  functionality are also mentioned. Help pages for deprecated functions are
  available at \code{help("-deprecated")}.

\code{generate_cont_indices} creates a data frame of the strata-weighed
  continental indices by year. This data frame can then be used to
  generate a population trajectory of the species.

\code{generate_cont_trend} calculates the geometric mean annual changes in population size.

\code{generate_regional_indices} creates a data frame of the strata-weighted
  regional indices by year. This data frame can then be used to
  generate a population trajectory of the species.

\code{generate_regional_trends} calculates the geometric mean annual changes in population size for composite regions.

\code{generate_strata_indices} creates a data frame of indices by year,
  factored by each stratum. These indicies can be used to generate
  trajectory plots of the species for each strata.

\code{generate_strata_trends} creates a data frame of trends by year,
  factored by each stratum. These trends are calculated using the indices
  generated by \code{generate_strata_indices}.

\code{p_waic} calculates effective number of parameters. This is
  used as a bias adjustment factor in the calculation of WAIC
  in the function \code{waic}.

Generates the trajectory plot of continental indices.

\code{prepare_jags_data} subsets raw BBS data by selected species and
   and wrangles stratified data for use as input to run JAGS models.

\code{waic} returns the Watanabe–Akaike information criterion (WAIC) for the
  supplied model. WAIC is a generalization of the Akaike information
  criterion onto singular statistical model.
}
\details{
NOTE: in order to calculated pWAIC, the model MUST track the parameter
  "lambda". In species that are data-rich, such as Wood Thrush,
  this produces extremely large JAGS objects, and takes up a considerable
  amount of memory when simulating with \code{run_model}

NOTE: in order to calculated WAIC, the model MUST track the parameter
  "lambda". In species that are data-rich, such as Wood Thrush,
  this produces extremely large JAGS objects, and takes up a considerable
  amount of memory when simulating with \code{run_model}

  See examples for details.
}
\section{\code{generate_cont_indices}}{

  For \code{generate_cont_indices()}, use
  \code{generate_indices(regions = "continental")}.
}

\section{\code{generate_cont_trend}}{

  For \code{generate_cont_trend()}, use
  \code{generate_trends()}.
}

\section{\code{generate_regional_indices}}{

  For \code{generate_regional_indices()}, use
  \code{generate_indices()}.
}

\section{\code{generate_regional_trends}}{

  For \code{generate_regional_trends()}, use
  \code{generate_trends()}.
}

\section{\code{generate_strata_indices}}{

  For \code{generate_strata_indices()}, use
  \code{generate_indices(regions = "stratum")}.
}

\section{\code{generate_strata_trends}}{

  For \code{generate_strata_trends()}, use
  \code{generate_trends()}.
}

\section{\code{p_waic}}{

  WAIC should no longer be used for BBS data.
  Cross validation should be used instead.
}

\section{\code{plot_cont_indices}}{

  For \code{plot_cont_indices()}, use \code{plot_indices()}.
}

\section{\code{prepare_jags_data}}{

  For \code{prepare_jags_data()}, use
  \code{prepare_data(sampler = "jags", ...)}.
}

\section{\code{waic}}{

  WAIC should no longer be used for BBS data.
  Cross validation should be used instead.
}

\examples{
# Toy example with Pacific Wren sample data
# First, stratify the sample data

strat_data <- stratify(by = "bbs_cws", sample_data = TRUE)

# Prepare the stratified data for use in a JAGS model. In this
#   toy example, we will set the minimum year as 2009 and
#   maximum year as 2018, effectively only setting up to
#   model 10 years of data. We will use the "first difference
#   model.
jags_data <- prepare_jags_data(strat_data = strat_data,
                               species_to_run = "Pacific Wren",
                               model = "firstdiff",
                               min_year = 2009,
                               max_year = 2018)

# You can also specify the GAM model, with an optional number of
# knots to use for the GAM basis.
# By default, the number of knots will be equal to the floor
# of the total unique years for the species / 4
jags_data <- prepare_jags_data(strat_data = strat_data,
                               species_to_run = "Pacific Wren",
                               model = "gam",
                               n_knots = 9)


}
\seealso{
\code{\link{generate_cont_indices}}

\code{\link{generate_cont_trend}}

\code{\link{generate_regional_indices}}

\code{\link{generate_regional_trends}}

\code{\link{generate_strata_indices}}

\code{\link{generate_strata_trends}}

\code{\link{p_waic}}

\code{\link{plot_cont_indices}}

\code{\link{prepare_jags_data}}

\code{\link{waic}}
}
\keyword{internal}
