% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_bcgam.R
\name{predict.bcgam}
\alias{predict.bcgam}
\title{Predict method for \pkg{bcgam} fits}
\usage{
\method{predict}{bcgam}(object, newdata, interval = c("credible"),
  level = 0.95, parameter = c("mu"), ...)
}
\arguments{
\item{object}{Object of class inheriting from "bcgam".}

\item{newdata}{An optional data frame in which to look for variable with which to predict.}

\item{interval}{Type of interval calculation. It can be either \code{"credible"} or \code{"prediction"}.
If \code{interval=prediction}, then a summary of the predictive posterior distribution is shown.}

\item{level}{Tolerance/credible level. The default is \code{0.95}.}

\item{parameter}{The type of parameter to predict. If parameter=\code{"eta"}, then the systematic component
\eqn{\eta} is predicted. If parameter=\code{"mu"}, then the mean value \eqn{\mu} obtained by transforming
\eqn{\eta} using the inverse of the link function is predicted. The default is \eqn{\mu}. If 
\code{interval="prediction"}, then this variable is ignored.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{predict.bcgam} produces a list of predictions, standard errors, and bounds based
on the posterior disitribution in the \code{bcgam} object.

If \code{interval="credible"}, a list with the following components is returned:
\item{cred.mean}{the mean values.}
\item{cred.sd}{standard error of mean values.}
\item{cred.lower}{lower bound of mean values.}
\item{cred.upper}{upper bound of mean values.}
If \code{interval="prediction"}, a list with the following components is returned:
\item{pred.mean}{the predicted values.}
\item{pred.sd}{standard error of predicted values.}
\item{pred.lower}{lower bound of predicted values.}
\item{pred.upper}{upper bound of predicted values.}
}
\description{
Predicted values based on \pkg{bcgam} object.
}
\details{
\code{predict.bcgam} produces estimated values, standard errors,
and interval estimates; obtained by the
fitted model in the frame \code{newdata}. Setting \code{intervals} 
specifies computation of credible or prediction (tolerance) intervals at the
specified \code{level}. 

All predictions are based on the posterior distribution in the \code{bcgam} object.
}
\examples{
\dontrun{
n<-50
x<-(1:n)^{1/3}
z<-as.factor(rbinom(n, 1, 0.6))
y<-x+7*as.numeric(z)+rnorm(n,sd=2) 
bcgam.fit <- bcgam(y~sm.incr(x)+z, nloop=100)
predict(bcgam.fit, newdata=data.frame(x=0.5, z="1"), parameter="mu", interval="prediction")
}
}
\author{
Cristian Oliva-Aviles and Mary C. Meyer
}
\keyword{internal}
