% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cded.R
\name{cded_raster}
\alias{cded_raster}
\title{Get Canadian Digital Elevation Model (CDED) as a \code{raster} object}
\usage{
cded_raster(
  aoi = NULL,
  tiles_50K = NULL,
  .predicate = sf::st_intersects,
  dest_vrt = tempfile(fileext = ".vrt"),
  ask = interactive(),
  check_tiles = TRUE,
  ...
)
}
\arguments{
\item{aoi}{Area of Interest. Currently supports sf and sp polygons, stars and raster objects.}

\item{tiles_50K}{a character vector of 1:50,000 NTS mapsheet tiles}

\item{.predicate}{geometry predicate function used to find the mapsheets from your aoi. Default \link[sf:geos_binary_pred]{sf::st_intersects}.}

\item{dest_vrt}{The location of the vrt file. Defaults to a temporary file, but can be overridden if you'd like to save it for a project}

\item{ask}{Should the function ask the user before downloading the data to a cache? Defaults to the value of interactive().}

\item{check_tiles}{Should the tiles that you already have in your cache be checked to see if they need updating? Default \code{TRUE}.
If you are running the same code frequently and are confident the tiles haven't changed, setting this to \code{FALSE}
will speed things up.}

\item{...}{Further arguments passed on to \link[raster:raster]{raster::raster}}
}
\value{
a \code{raster} object of the cded tiles for the specified area of interest
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}.
}
\examples{
\dontrun{
vic <- census_subdivision()[census_subdivision()$CENSUS_SUBDIVISION_NAME == "Victoria", ]
vic_cded <- cded_raster(aoi = vic)
}
}
\keyword{internal}
